# include "ranlib.h"
# include <cstdio>   
# include <cstdlib>  
# include <cmath>    
# include <iostream>
# include <string> 
# include <fstream>
# include "nrutil.h"
# include <ctime>
# include "matrix_tool.h"
# include "stat_tool.h"
# include "BaggingProcedure.h"




using namespace std; 

unsigned int congrval,tausval; // for random number

/********************* main function *********************/



int main (int argc, char * argv[]) {
    
    
    
/********************* student t distribution (df, 0.975 percentile, 0.99, 0.995 percentile)*********************/
    
    float t_distribution[33][4]={
        
        1,	12.706,	31.821, 63.656,
        2,	4.303,	6.965,  9.925,
        3,	3.182,	4.541,  5.841,
        4,	2.776,	3.747,  4.604,
        5,	2.571,	3.365,  4.032,
        6,	2.447,	3.143,  3.707,
        7,	2.365,	2.998,  3.499,
        8,	2.306,	2.896,  3.355,
        9,	2.262,	2.821,  3.25,
        10,	2.228,	2.764,  3.169,
        11,	2.201,	2.718,  3.106,
        12,	2.179,	2.681,  3.055,
        13,	2.16,	2.650,  3.012,
        14,	2.145,	2.624,  2.977,
        15,	2.131,	2.602,  2.947,
        16,	2.12,	2.583,  2.921,
        17,	2.11,	2.567,  2.898,
        18,	2.101,	2.552,  2.878,
        19,	2.093,	2.539,  2.861,
        20,	2.086,	2.528,  2.845,
        21,	2.08,	2.518,  2.831,
        22,	2.074,	2.508,  2.819,
        23,	2.069,	2.500,  2.807,
        24,	2.064,	2.492,  2.797,
        25,	2.06,	2.485,  2.787,
        26,	2.056,	2.479,  2.779,
        27,	2.052,	2.473,  2.771,
        28,	2.048,	2.467,  2.763,
        29,	2.045,	2.462,  2.756,
        30,	2.042,	2.457,  2.75,
        60,	2,      2.390,  2.66,
        120,1.98,	2.358,  2.617,
        1000,1.96,	2.326,  2.576    
        
    };
    
    //// the 0.9, 0.95, 0.975, 0.99, 0.999 quantile of chi-distribution /////
    float chi_distribution[265][6]={
        
        1	,	2.706	,	3.841	,	5.024	,	6.635	,	10.828	,
        2	,	4.605	,	5.991	,	7.378	,	9.21	,	13.816	,
        3	,	6.251	,	7.815	,	9.348	,	11.345	,	16.266	,
        4	,	7.779	,	9.488	,	11.143	,	13.277	,	18.467	,
        5	,	9.236	,	11.07	,	12.833	,	15.086	,	20.515	,
        6	,	10.645	,	12.592	,	14.449	,	16.812	,	22.458	,
        7	,	12.017	,	14.067	,	16.013	,	18.475	,	24.322	,
        8	,	13.362	,	15.507	,	17.535	,	20.09	,	26.124	,
        9	,	14.684	,	16.919	,	19.023	,	21.666	,	27.877	,
        10	,	15.987	,	18.307	,	20.483	,	23.209	,	29.588	,
        11	,	17.275	,	19.675	,	21.92	,	24.725	,	31.264	,
        12	,	18.549	,	21.026	,	23.337	,	26.217	,	32.909	,
        13	,	19.812	,	22.362	,	24.736	,	27.688	,	34.528	,
        14	,	21.064	,	23.685	,	26.119	,	29.141	,	36.123	,
        15	,	22.307	,	24.996	,	27.488	,	30.578	,	37.697	,
        16	,	23.542	,	26.296	,	28.845	,	32	,       39.252	,
        17	,	24.769	,	27.587	,	30.191	,	33.409	,	40.79	,
        18	,	25.989	,	28.869	,	31.526	,	34.805	,	42.312	,
        19	,	27.204	,	30.144	,	32.852	,	36.191	,	43.82	,
        20	,	28.412	,	31.41	,	34.17	,	37.566	,	45.315	,
        21	,	29.615	,	32.671	,	35.479	,	38.932	,	46.797	,
        22	,	30.813	,	33.924	,	36.781	,	40.289	,	48.268	,
        23	,	32.007	,	35.172	,	38.076	,	41.638	,	49.728	,
        24	,	33.196	,	36.415	,	39.364	,	42.98	,	51.179	,
        25	,	34.382	,	37.652	,	40.646	,	44.314	,	52.62	,
        26	,	35.563	,	38.885	,	41.923	,	45.642	,	54.052	,
        27	,	36.741	,	40.113	,	43.195	,	46.963	,	55.476	,
        28	,	37.916	,	41.337	,	44.461	,	48.278	,	56.892	,
        29	,	39.087	,	42.557	,	45.722	,	49.588	,	58.301	,
        30	,	40.256	,	43.773	,	46.979	,	50.892	,	59.703	,
        31	,	41.422	,	44.985	,	48.232	,	52.191	,	61.098	,
        32	,	42.585	,	46.194	,	49.48	,	53.486	,	62.487	,
        33	,	43.745	,	47.4	,	50.725	,	54.776	,	63.87	,
        34	,	44.903	,	48.602	,	51.966	,	56.061	,	65.247	,
        35	,	46.059	,	49.802	,	53.203	,	57.342	,	66.619	,
        36	,	47.212	,	50.998	,	54.437	,	58.619	,	67.985	,
        37	,	48.363	,	52.192	,	55.668	,	59.893	,	69.346	,
        38	,	49.513	,	53.384	,	56.896	,	61.162	,	70.703	,
        39	,	50.66	,	54.572	,	58.12	,	62.428	,	72.055	,
        40	,	51.805	,	55.758	,	59.342	,	63.691	,	73.402	,
        41	,	52.949	,	56.942	,	60.561	,	64.95	,	74.745	,
        42	,	54.09	,	58.124	,	61.777	,	66.206	,	76.084	,
        43	,	55.23	,	59.304	,	62.99	,	67.459	,	77.419	,
        44	,	56.369	,	60.481	,	64.201	,	68.71	,	78.75	,
        45	,	57.505	,	61.656	,	65.41	,	69.957	,	80.077	,
        46	,	58.641	,	62.83	,	66.617	,	71.201	,	81.4	,
        47	,	59.774	,	64.001	,	67.821	,	72.443	,	82.72	,
        48	,	60.907	,	65.171	,	69.023	,	73.683	,	84.037	,
        49	,	62.038	,	66.339	,	70.222	,	74.919	,	85.351	,
        50	,	63.167	,	67.505	,	71.42	,	76.154	,	86.661	,
        51	,	64.295	,	68.669	,	72.616	,	77.386	,	87.968	,
        52	,	65.422	,	69.832	,	73.81	,	78.616	,	89.272	,
        53	,	66.548	,	70.993	,	75.002	,	79.843	,	90.573	,
        54	,	67.673	,	72.153	,	76.192	,	81.069	,	91.872	,
        55	,	68.796	,	73.311	,	77.38	,	82.292	,	93.168	,
        56	,	69.919	,	74.468	,	78.567	,	83.513	,	94.461	,
        57	,	71.04	,	75.624	,	79.752	,	84.733	,	95.751	,
        58	,	72.16	,	76.778	,	80.936	,	85.95	,	97.039	,
        59	,	73.279	,	77.931	,	82.117	,	87.166	,	98.324	,
        60	,	74.397	,	79.082	,	83.298	,	88.379	,	99.607	,
        61	,	75.514	,	80.232	,	84.476	,	89.591	,	100.888	,
        62	,	76.63	,	81.381	,	85.654	,	90.802	,	102.166	,
        63	,	77.745	,	82.529	,	86.83	,	92.01	,	103.442	,
        64	,	78.86	,	83.675	,	88.004	,	93.217	,	104.716	,
        65	,	79.973	,	84.821	,	89.177	,	94.422	,	105.988	,
        66	,	81.085	,	85.965	,	90.349	,	95.626	,	107.258	,
        67	,	82.197	,	87.108	,	91.519	,	96.828	,	108.526	,
        68	,	83.308	,	88.25	,	92.689	,	98.028	,	109.791	,
        69	,	84.418	,	89.391	,	93.856	,	99.228	,	111.055	,
        70	,	85.527	,	90.531	,	95.023	,	100.425	,	112.317	,
        71	,	86.635	,	91.67	,	96.189	,	101.621	,	113.577	,
        72	,	87.743	,	92.808	,	97.353	,	102.816	,	114.835	,
        73	,	88.85	,	93.945	,	98.516	,	104.01	,	116.092	,
        74	,	89.956	,	95.081	,	99.678	,	105.202	,	117.346	,
        75	,	91.061	,	96.217	,	100.839	,	106.393	,	118.599	,
        76	,	92.166	,	97.351	,	101.999	,	107.583	,	119.85	,
        77	,	93.27	,	98.484	,	103.158	,	108.771	,	121.1	,
        78	,	94.374	,	99.617	,	104.316	,	109.958	,	122.348	,
        79	,	95.476	,	100.749	,	105.473	,	111.144	,	123.594	,
        80	,	96.578	,	101.879	,	106.629	,	112.329	,	124.839	,
        81	,	97.68	,	103.01	,	107.783	,	113.512	,	126.083	,
        82	,	98.78	,	104.139	,	108.937	,	114.695	,	127.324	,
        83	,	99.88	,	105.267	,	110.09	,	115.876	,	128.565	,
        84	,	100.98	,	106.395	,	111.242	,	117.057	,	129.804	,
        85	,	102.079	,	107.522	,	112.393	,	118.236	,	131.041	,
        86	,	103.177	,	108.648	,	113.544	,	119.414	,	132.277	,
        87	,	104.275	,	109.773	,	114.693	,	120.591	,	133.512	,
        88	,	105.372	,	110.898	,	115.841	,	121.767	,	134.745	,
        89	,	106.469	,	112.022	,	116.989	,	122.942	,	135.978	,
        90	,	107.565	,	113.145	,	118.136	,	124.116	,	137.208	,
        91	,	108.661	,	114.268	,	119.282	,	125.289	,	138.438	,
        92	,	109.756	,	115.39	,	120.427	,	126.462	,	139.666	,
        93	,	110.85	,	116.511	,	121.571	,	127.633	,	140.893	,
        94	,	111.944	,	117.632	,	122.715	,	128.803	,	142.119	,
        95	,	113.038	,	118.752	,	123.858	,	129.973	,	143.344	,
        96	,	114.131	,	119.871	,	125	,       131.141	,	144.567	,
        97	,	115.223	,	120.99	,	126.141	,	132.309	,	145.789	,
        98	,	116.315	,	122.108	,	127.282	,	133.476	,	147.01	,
        99	,	117.407	,	123.225	,	128.422	,	134.642	,	148.23	,
        100	,	118.498	,	124.342	,	129.561	,	135.807	,	149.449	,
        101	,	119.589	,	125.458	,	130.7	,	136.971	,	150.667	,
        102	,	120.679	,	126.574	,	131.838	,	138.134	,	151.884	,
        103	,	121.769	,	127.689	,	132.975	,	139.297	,	153.099	,
        104	,	122.858	,	128.804	,	134.111	,	140.459	,	154.314	,
        105	,	123.947	,	129.918	,	135.247	,	141.62	,	155.528	,
        106	,	125.035	,	131.031	,	136.382	,	142.78	,	156.74	,
        107	,	126.123	,	132.144	,	137.517	,	143.94	,	157.952	,
        108	,	127.211	,	133.257	,	138.651	,	145.099	,	159.162	,
        109	,	128.298	,	134.369	,	139.784	,	146.257	,	160.372	,
        110	,	129.385	,	135.48	,	140.917	,	147.414	,	161.581	,
        111	,	130.472	,	136.591	,	142.049	,	148.571	,	162.788	,
        112	,	131.558	,	137.701	,	143.18	,	149.727	,	163.995	,
        113	,	132.643	,	138.811	,	144.311	,	150.882	,	165.201	,
        114	,	133.729	,	139.921	,	145.441	,	152.037	,	166.406	,
        115	,	134.813	,	141.03	,	146.571	,	153.191	,	167.61	,
        116	,	135.898	,	142.138	,	147.7	,	154.344	,	168.813	,
        117	,	136.982	,	143.246	,	148.829	,	155.496	,	170.016	,
        118	,	138.066	,	144.354	,	149.957	,	156.648	,	171.217	,
        119	,	139.149	,	145.461	,	151.084	,	157.8	,	172.418	,
        120	,	140.233	,	146.567	,	152.211	,	158.95	,	173.617	,
        121	,	141.315	,	147.674	,	153.338	,	160.1	,	174.816	,
        122	,	142.398	,	148.779	,	154.464	,	161.25	,	176.014	,
        123	,	143.48	,	149.885	,	155.589	,	162.398	,	177.212	,
        124	,	144.562	,	150.989	,	156.714	,	163.546	,	178.408	,
        125	,	145.643	,	152.094	,	157.839	,	164.694	,	179.604	,
        126	,	146.724	,	153.198	,	158.962	,	165.841	,	180.799	,
        127	,	147.805	,	154.302	,	160.086	,	166.987	,	181.993	,
        128	,	148.885	,	155.405	,	161.209	,	168.133	,	183.186	,
        129	,	149.965	,	156.508	,	162.331	,	169.278	,	184.379	,
        130	,	151.045	,	157.61	,	163.453	,	170.423	,	185.571	,
        131	,	152.125	,	158.712	,	164.575	,	171.567	,	186.762	,
        132	,	153.204	,	159.814	,	165.696	,	172.711	,	187.953	,
        133	,	154.283	,	160.915	,	166.816	,	173.854	,	189.142	,
        134	,	155.361	,	162.016	,	167.936	,	174.996	,	190.331	,
        135	,	156.44	,	163.116	,	169.056	,	176.138	,	191.52	,
        136	,	157.518	,	164.216	,	170.175	,	177.28	,	192.707	,
        137	,	158.595	,	165.316	,	171.294	,	178.421	,	193.894	,
        138	,	159.673	,	166.415	,	172.412	,	179.561	,	195.08	,
        139	,	160.75	,	167.514	,	173.53	,	180.701	,	196.266	,
        140	,	161.827	,	168.613	,	174.648	,	181.84	,	197.451	,
        141	,	162.904	,	169.711	,	175.765	,	182.979	,	198.635	,
        142	,	163.98	,	170.809	,	176.882	,	184.118	,	199.819	,
        143	,	165.056	,	171.907	,	177.998	,	185.256	,	201.002	,
        144	,	166.132	,	173.004	,	179.114	,	186.393	,	202.184	,
        145	,	167.207	,	174.101	,	180.229	,	187.53	,	203.366	,
        146	,	168.283	,	175.198	,	181.344	,	188.666	,	204.547	,
        147	,	169.358	,	176.294	,	182.459	,	189.802	,	205.727	,
        148	,	170.432	,	177.39	,	183.573	,	190.938	,	206.907	,
        149	,	171.507	,	178.485	,	184.687	,	192.073	,	208.086	,
        150	,	172.581	,	179.581	,	185.8	,	193.208	,	209.265	,
        151	,	173.655	,	180.676	,	186.914	,	194.342	,	210.443	,
        152	,	174.729	,	181.77	,	188.026	,	195.476	,	211.62	,
        153	,	175.803	,	182.865	,	189.139	,	196.609	,	212.797	,
        154	,	176.876	,	183.959	,	190.251	,	197.742	,	213.973	,
        155	,	177.949	,	185.052	,	191.362	,	198.874	,	215.149	,
        156	,	179.022	,	186.146	,	192.474	,	200.006	,	216.324	,
        157	,	180.094	,	187.239	,	193.584	,	201.138	,	217.499	,
        158	,	181.167	,	188.332	,	194.695	,	202.269	,	218.673	,
        159	,	182.239	,	189.424	,	195.805	,	203.4	,	219.846	,
        160	,	183.311	,	190.516	,	196.915	,	204.53	,	221.019	,
        161	,	184.382	,	191.608	,	198.025	,	205.66	,	222.191	,
        162	,	185.454	,	192.7	,	199.134	,	206.79	,	223.363	,
        163	,	186.525	,	193.791	,	200.243	,	207.919	,	224.535	,
        164	,	187.596	,	194.883	,	201.351	,	209.047	,	225.705	,
        165	,	188.667	,	195.973	,	202.459	,	210.176	,	226.876	,
        166	,	189.737	,	197.064	,	203.567	,	211.304	,	228.045	,
        167	,	190.808	,	198.154	,	204.675	,	212.431	,	229.215	,
        168	,	191.878	,	199.244	,	205.782	,	213.558	,	230.383	,
        169	,	192.948	,	200.334	,	206.889	,	214.685	,	231.552	,
        170	,	194.017	,	201.423	,	207.995	,	215.812	,	232.719	,
        171	,	195.087	,	202.513	,	209.102	,	216.938	,	233.887	,
        172	,	196.156	,	203.602	,	210.208	,	218.063	,	235.053	,
        173	,	197.225	,	204.69	,	211.313	,	219.189	,	236.22	,
        174	,	198.294	,	205.779	,	212.419	,	220.314	,	237.385	,
        175	,	199.363	,	206.867	,	213.524	,	221.438	,	238.551	,
        176	,	200.432	,	207.955	,	214.628	,	222.563	,	239.716	,
        177	,	201.5	,	209.042	,	215.733	,	223.687	,	240.88	,
        178	,	202.568	,	210.13	,	216.837	,	224.81	,	242.044	,
        179	,	203.636	,	211.217	,	217.941	,	225.933	,	243.207	,
        180	,	204.704	,	212.304	,	219.044	,	227.056	,	244.37	,
        181	,	205.771	,	213.391	,	220.148	,	228.179	,	245.533	,
        182	,	206.839	,	214.477	,	221.251	,	229.301	,	246.695	,
        183	,	207.906	,	215.563	,	222.353	,	230.423	,	247.857	,
        184	,	208.973	,	216.649	,	223.456	,	231.544	,	249.018	,
        185	,	210.04	,	217.735	,	224.558	,	232.665	,	250.179	,
        186	,	211.106	,	218.82	,	225.66	,	233.786	,	251.339	,
        187	,	212.173	,	219.906	,	226.761	,	234.907	,	252.499	,
        188	,	213.239	,	220.991	,	227.863	,	236.027	,	253.659	,
        189	,	214.305	,	222.076	,	228.964	,	237.147	,	254.818	,
        190	,	215.371	,	223.16	,	230.064	,	238.266	,	255.976	,
        191	,	216.437	,	224.245	,	231.165	,	239.386	,	257.135	,
        192	,	217.502	,	225.329	,	232.265	,	240.505	,	258.292	,
        193	,	218.568	,	226.413	,	233.365	,	241.623	,	259.45	,
        194	,	219.633	,	227.496	,	234.465	,	242.742	,	260.607	,
        195	,	220.698	,	228.58	,	235.564	,	243.86	,	261.763	,
        196	,	221.763	,	229.663	,	236.664	,	244.977	,	262.92	,
        197	,	222.828	,	230.746	,	237.763	,	246.095	,	264.075	,
        198	,	223.892	,	231.829	,	238.861	,	247.212	,	265.231	,
        199	,	224.957	,	232.912	,	239.96	,	248.329	,	266.386	,
        200	,	226.021	,	233.994	,	241.058	,	249.445	,	267.541	,
        201	,	227.085	,	235.077	,	242.156	,	250.561	,	268.695	,
        202	,	228.149	,	236.159	,	243.254	,	251.677	,	269.849	,
        203	,	229.213	,	237.24	,	244.351	,	252.793	,	271.002	,
        204	,	230.276	,	238.322	,	245.448	,	253.908	,	272.155	,
        205	,	231.34	,	239.403	,	246.545	,	255.023	,	273.308	,
        206	,	232.403	,	240.485	,	247.642	,	256.138	,	274.46	,
        207	,	233.466	,	241.566	,	248.739	,	257.253	,	275.612	,
        208	,	234.529	,	242.647	,	249.835	,	258.367	,	276.764	,
        209	,	235.592	,	243.727	,	250.931	,	259.481	,	277.915	,
        210	,	236.655	,	244.808	,	252.027	,	260.595	,	279.066	,
        211	,	237.717	,	245.888	,	253.122	,	261.708	,	280.217	,
        212	,	238.78	,	246.968	,	254.218	,	262.821	,	281.367	,
        213	,	239.842	,	248.048	,	255.313	,	263.934	,	282.517	,
        214	,	240.904	,	249.128	,	256.408	,	265.047	,	283.666	,
        215	,	241.966	,	250.207	,	257.503	,	266.159	,	284.815	,
        216	,	243.028	,	251.286	,	258.597	,	267.271	,	285.964	,
        217	,	244.09	,	252.365	,	259.691	,	268.383	,	287.112	,
        218	,	245.151	,	253.444	,	260.785	,	269.495	,	288.261	,
        219	,	246.213	,	254.523	,	261.879	,	270.606	,	289.408	,
        220	,	247.274	,	255.602	,	262.973	,	271.717	,	290.556	,
        221	,	248.335	,	256.68	,	264.066	,	272.828	,	291.703	,
        222	,	249.396	,	257.758	,	265.159	,	273.939	,	292.85	,
        223	,	250.457	,	258.837	,	266.252	,	275.049	,	293.996	,
        224	,	251.517	,	259.914	,	267.345	,	276.159	,	295.142	,
        225	,	252.578	,	260.992	,	268.438	,	277.269	,	296.288	,
        226	,	253.638	,	262.07	,	269.53	,	278.379	,	297.433	,
        227	,	254.699	,	263.147	,	270.622	,	279.488	,	298.579	,
        228	,	255.759	,	264.224	,	271.714	,	280.597	,	299.723	,
        229	,	256.819	,	265.301	,	272.806	,	281.706	,	300.868	,
        230	,	257.879	,	266.378	,	273.898	,	282.814	,	302.012	,
        231	,	258.939	,	267.455	,	274.989	,	283.923	,	303.156	,
        232	,	259.998	,	268.531	,	276.08	,	285.031	,	304.299	,
        233	,	261.058	,	269.608	,	277.171	,	286.139	,	305.443	,
        234	,	262.117	,	270.684	,	278.262	,	287.247	,	306.586	,
        235	,	263.176	,	271.76	,	279.352	,	288.354	,	307.728	,
        236	,	264.235	,	272.836	,	280.443	,	289.461	,	308.871	,
        237	,	265.294	,	273.911	,	281.533	,	290.568	,	310.013	,
        238	,	266.353	,	274.987	,	282.623	,	291.675	,	311.154	,
        239	,	267.412	,	276.062	,	283.713	,	292.782	,	312.296	,
        240	,	268.471	,	277.138	,	284.802	,	293.888	,	313.437	,
        241	,	269.529	,	278.213	,	285.892	,	294.994	,	314.578	,
        242	,	270.588	,	279.288	,	286.981	,	296.1	,	315.718	,
        243	,	271.646	,	280.362	,	288.07	,	297.206	,	316.859	,
        244	,	272.704	,	281.437	,	289.159	,	298.311	,	317.999	,
        245	,	273.762	,	282.511	,	290.248	,	299.417	,	319.138	,
        246	,	274.82	,	283.586	,	291.336	,	300.522	,	320.278	,
        247	,	275.878	,	284.66	,	292.425	,	301.626	,	321.417	,
        248	,	276.935	,	285.734	,	293.513	,	302.731	,	322.556	,
        249	,	277.993	,	286.808	,	294.601	,	303.835	,	323.694	,
        250	,	279.05	,	287.882	,	295.689	,	304.94	,	324.832	,
        300	,	331.789	,	341.395	,	349.874	,	359.906	,	381.425	,
        350	,	384.306	,	394.626	,	403.723	,	414.474	,	437.488	,
        400	,	436.649	,	447.632	,	457.305	,	468.724	,	493.132	,
        450	,	488.849	,	500.456	,	510.67	,	522.717	,	548.432	,
        500	,	540.93	,	553.127	,	563.852	,	576.493	,	603.446	,
        550	,	592.909	,	605.667	,	616.878	,	630.084	,	658.215	,
        600	,	644.8	,	658.094	,	669.769	,	683.516	,	712.771	,
        650	,	696.614	,	710.421	,	722.542	,	736.807	,	767.141	,
        700	,	748.359	,	762.661	,	775.211	,	789.974	,	821.347	,
        750	,	800.043	,	814.822	,	827.785	,	843.029	,	875.404	,
        800	,	851.671	,	866.911	,	880.275	,	895.984	,	929.329	,
        850	,	903.249	,	918.937	,	932.689	,	948.848	,	983.133	,
        900	,	954.782	,	970.904	,	985.032	,	1001.63	,	1036.826,
        950	,	1006.272,	1022.816,	1037.311,	1054.334,	1090.418,
        1000,	1057.724,	1074.679,	1089.531,	1106.969,	1143.917	    
    };
    
    
    
    
    float f_distribution[35][20]={
        0	,	1		,	2		,	3		,	4		,	5	,	6	,	7	,	8	,	9	,	10	,	12	,	15	,	20	,	24	,	30	,	40	,	60	,	120	,	1000	,
        1	,	161.4476,	199.5	,	215.7073	,	224.5832	,	230.1619	,	233.986	,	236.7684	,	238.8827	,	240.5433	,	241.8817	,	243.906	,	245.9499	,	248.0131	,	249.0518	,	250.0951	,	251.1432	,	252.1957	,	253.2529	,	254.3144	,
        2	,	18.5128	,	19	,	19.1643	,	19.2468	,	19.2964	,	19.3295	,	19.3532	,	19.371	,	19.3848	,	19.3959	,	19.4125	,	19.4291	,	19.4458	,	19.4541	,	19.4624	,	19.4707	,	19.4791	,	19.4874	,	19.4957	,
        3	,	10.128	,	9.5521	,	9.2766	,	9.1172	,	9.0135	,	8.9406	,	8.8867	,	8.8452	,	8.8123	,	8.7855	,	8.7446	,	8.7029	,	8.6602	,	8.6385	,	8.6166	,	8.5944	,	8.572	,	8.5494	,	8.5264	,
        4	,	7.7086	,	6.9443	,	6.5914	,	6.3882	,	6.2561	,	6.1631	,	6.0942	,	6.041	,	5.9988	,	5.9644	,	5.9117	,	5.8578	,	5.8025	,	5.7744	,	5.7459	,	5.717	,	5.6877	,	5.6581	,	5.6281	,
        5	,	6.6079	,	5.7861	,	5.4095	,	5.1922	,	5.0503	,	4.9503	,	4.8759	,	4.8183	,	4.7725	,	4.7351	,	4.6777	,	4.6188	,	4.5581	,	4.5272	,	4.4957	,	4.4638	,	4.4314	,	4.3985	,	4.365	,
        6	,	5.9874	,	5.1433	,	4.7571	,	4.5337	,	4.3874	,	4.2839	,	4.2067	,	4.1468	,	4.099	,	4.06	,	3.9999	,	3.9381	,	3.8742	,	3.8415	,	3.8082	,	3.7743	,	3.7398	,	3.7047	,	3.6689	,
        7	,	5.5914	,	4.7374	,	4.3468	,	4.1203	,	3.9715	,	3.866	,	3.787	,	3.7257	,	3.6767	,	3.6365	,	3.5747	,	3.5107	,	3.4445	,	3.4105	,	3.3758	,	3.3404	,	3.3043	,	3.2674	,	3.2298	,
        8	,	5.3177	,	4.459	,	4.0662	,	3.8379	,	3.6875	,	3.5806	,	3.5005	,	3.4381	,	3.3881	,	3.3472	,	3.2839	,	3.2184	,	3.1503	,	3.1152	,	3.0794	,	3.0428	,	3.0053	,	2.9669	,	2.9276	,
        9	,	5.1174	,	4.2565	,	3.8625	,	3.6331	,	3.4817	,	3.3738	,	3.2927	,	3.2296	,	3.1789	,	3.1373	,	3.0729	,	3.0061	,	2.9365	,	2.9005	,	2.8637	,	2.8259	,	2.7872	,	2.7475	,	2.7067	,
        10	,	4.9646	,	4.1028	,	3.7083	,	3.478	,	3.3258	,	3.2172	,	3.1355	,	3.0717	,	3.0204	,	2.9782	,	2.913	,	2.845	,	2.774	,	2.7372	,	2.6996	,	2.6609	,	2.6211	,	2.5801	,	2.5379	,
        11	,	4.8443	,	3.9823	,	3.5874	,	3.3567	,	3.2039	,	3.0946	,	3.0123	,	2.948	,	2.8962	,	2.8536	,	2.7876	,	2.7186	,	2.6464	,	2.609	,	2.5705	,	2.5309	,	2.4901	,	2.448	,	2.4045	,
        12	,	4.7472	,	3.8853	,	3.4903	,	3.2592	,	3.1059	,	2.9961	,	2.9134	,	2.8486	,	2.7964	,	2.7534	,	2.6866	,	2.6169	,	2.5436	,	2.5055	,	2.4663	,	2.4259	,	2.3842	,	2.341	,	2.2962	,
        13	,	4.6672	,	3.8056	,	3.4105	,	3.1791	,	3.0254	,	2.9153	,	2.8321	,	2.7669	,	2.7144	,	2.671	,	2.6037	,	2.5331	,	2.4589	,	2.4202	,	2.3803	,	2.3392	,	2.2966	,	2.2524	,	2.2064	,
        14	,	4.6001	,	3.7389	,	3.3439	,	3.1122	,	2.9582	,	2.8477	,	2.7642	,	2.6987	,	2.6458	,	2.6022	,	2.5342	,	2.463	,	2.3879	,	2.3487	,	2.3082	,	2.2664	,	2.2229	,	2.1778	,	2.1307	,
        15	,	4.5431	,	3.6823	,	3.2874	,	3.0556	,	2.9013	,	2.7905	,	2.7066	,	2.6408	,	2.5876	,	2.5437	,	2.4753	,	2.4034	,	2.3275	,	2.2878	,	2.2468	,	2.2043	,	2.1601	,	2.1141	,	2.0658	,
        16	,	4.494	,	3.6337	,	3.2389	,	3.0069	,	2.8524	,	2.7413	,	2.6572	,	2.5911	,	2.5377	,	2.4935	,	2.4247	,	2.3522	,	2.2756	,	2.2354	,	2.1938	,	2.1507	,	2.1058	,	2.0589	,	2.0096	,
        17	,	4.4513	,	3.5915	,	3.1968	,	2.9647	,	2.81	,	2.6987	,	2.6143	,	2.548	,	2.4943	,	2.4499	,	2.3807	,	2.3077	,	2.2304	,	2.1898	,	2.1477	,	2.104	,	2.0584	,	2.0107	,	1.9604	,
        18	,	4.4139	,	3.5546	,	3.1599	,	2.9277	,	2.7729	,	2.6613	,	2.5767	,	2.5102	,	2.4563	,	2.4117	,	2.3421	,	2.2686	,	2.1906	,	2.1497	,	2.1071	,	2.0629	,	2.0166	,	1.9681	,	1.9168	,
        19	,	4.3807	,	3.5219	,	3.1274	,	2.8951	,	2.7401	,	2.6283	,	2.5435	,	2.4768	,	2.4227	,	2.3779	,	2.308	,	2.2341	,	2.1555	,	2.1141	,	2.0712	,	2.0264	,	1.9795	,	1.9302	,	1.878	,
        20	,	4.3512	,	3.4928	,	3.0984	,	2.8661	,	2.7109	,	2.599	,	2.514	,	2.4471	,	2.3928	,	2.3479	,	2.2776	,	2.2033	,	2.1242	,	2.0825	,	2.0391	,	1.9938	,	1.9464	,	1.8963	,	1.8432	,
        21	,	4.3248	,	3.4668	,	3.0725	,	2.8401	,	2.6848	,	2.5727	,	2.4876	,	2.4205	,	2.366	,	2.321	,	2.2504	,	2.1757	,	2.096	,	2.054	,	2.0102	,	1.9645	,	1.9165	,	1.8657	,	1.8117	,
        22	,	4.3009	,	3.4434	,	3.0491	,	2.8167	,	2.6613	,	2.5491	,	2.4638	,	2.3965	,	2.3419	,	2.2967	,	2.2258	,	2.1508	,	2.0707	,	2.0283	,	1.9842	,	1.938	,	1.8894	,	1.838	,	1.7831	,
        23	,	4.2793	,	3.4221	,	3.028	,	2.7955	,	2.64	,	2.5277	,	2.4422	,	2.3748	,	2.3201	,	2.2747	,	2.2036	,	2.1282	,	2.0476	,	2.005	,	1.9605	,	1.9139	,	1.8648	,	1.8128	,	1.757	,
        24	,	4.2597	,	3.4028	,	3.0088	,	2.7763	,	2.6207	,	2.5082	,	2.4226	,	2.3551	,	2.3002	,	2.2547	,	2.1834	,	2.1077	,	2.0267	,	1.9838	,	1.939	,	1.892	,	1.8424	,	1.7896	,	1.733	,
        25	,	4.2417	,	3.3852	,	2.9912	,	2.7587	,	2.603	,	2.4904	,	2.4047	,	2.3371	,	2.2821	,	2.2365	,	2.1649	,	2.0889	,	2.0075	,	1.9643	,	1.9192	,	1.8718	,	1.8217	,	1.7684	,	1.711	,
        26	,	4.2252	,	3.369	,	2.9752	,	2.7426	,	2.5868	,	2.4741	,	2.3883	,	2.3205	,	2.2655	,	2.2197	,	2.1479	,	2.0716	,	1.9898	,	1.9464	,	1.901	,	1.8533	,	1.8027	,	1.7488	,	1.6906	,
        27	,	4.21	,	3.3541	,	2.9604	,	2.7278	,	2.5719	,	2.4591	,	2.3732	,	2.3053	,	2.2501	,	2.2043	,	2.1323	,	2.0558	,	1.9736	,	1.9299	,	1.8842	,	1.8361	,	1.7851	,	1.7306	,	1.6717	,
        28	,	4.196	,	3.3404	,	2.9467	,	2.7141	,	2.5581	,	2.4453	,	2.3593	,	2.2913	,	2.236	,	2.19	,	2.1179	,	2.0411	,	1.9586	,	1.9147	,	1.8687	,	1.8203	,	1.7689	,	1.7138	,	1.6541	,
        29	,	4.183	,	3.3277	,	2.934	,	2.7014	,	2.5454	,	2.4324	,	2.3463	,	2.2783	,	2.2229	,	2.1768	,	2.1045	,	2.0275	,	1.9446	,	1.9005	,	1.8543	,	1.8055	,	1.7537	,	1.6981	,	1.6376	,
        30	,	4.1709	,	3.3158	,	2.9223	,	2.6896	,	2.5336	,	2.4205	,	2.3343	,	2.2662	,	2.2107	,	2.1646	,	2.0921	,	2.0148	,	1.9317	,	1.8874	,	1.8409	,	1.7918	,	1.7396	,	1.6835	,	1.6223	,
        40	,	4.0847	,	3.2317	,	2.8387	,	2.606	,	2.4495	,	2.3359	,	2.249	,	2.1802	,	2.124	,	2.0772	,	2.0035	,	1.9245	,	1.8389	,	1.7929	,	1.7444	,	1.6928	,	1.6373	,	1.5766	,	1.5089	,
        60	,	4.0012	,	3.1504	,	2.7581	,	2.5252	,	2.3683	,	2.2541	,	2.1665	,	2.097	,	2.0401	,	1.9926	,	1.9174	,	1.8364	,	1.748	,	1.7001	,	1.6491	,	1.5943	,	1.5343	,	1.4673	,	1.3893	,
        120	,	3.9201	,	3.0718	,	2.6802	,	2.4472	,	2.2899	,	2.175	,	2.0868	,	2.0164	,	1.9588	,	1.9105	,	1.8337	,	1.7505	,	1.6587	,	1.6084	,	1.5543	,	1.4952	,	1.429	,	1.3519	,	1.2539	,
        1000	,	3.8415	,	2.9957	,	2.6049	,	2.3719	,	2.2141	,	2.0986	,	2.0096	,	1.9384	,	1.8799	,	1.8307	,	1.7522	,	1.6664	,	1.5705	,	1.5173	,	1.4591	,	1.394	,	1.318	,	1.2214	,	1	
    };
    
      
     
    
/********************* reading input files *********************/
    
    int num_subject, 
        num_response, 
        num_covariate;
    
    int wald_df; // df for C matrix in wald test
    
    int projection_dim;// dimension after projection
    
        
    char name_response[400],
         name_covariate[400];
    
    char name_waldC[400];
	char name_waldC_basis[400];
    
    
    
    
    /////// user specified numbers, name of files input ///////
    
    cout << "Please enter the number of subjects (must be an positive integer): ";
    cin >> num_subject;
    cout << "Number of subjects is " << num_subject << endl << endl;
    
    cout << "Please enter the dimension of reponses (must be an positive integer): ";
    cin >> num_response;
    cout << "Dimension(s) of responses is " << num_response << endl << endl;
    
    cout << "Please enter the dimension of covariates excluding intercept(must be an positive integer):" << endl;
    cin >> num_covariate;
    cout << "Dimension(s) of covariates is "<< num_covariate << endl << endl;
    
    cout << "Please enter the degree of freedom of C matrix in hypothesis testing C'beta = 0:" << endl;
    cin >> wald_df;
    cout << "Degree of freedom in C matrix of hypothesis testing is "<< wald_df << endl << endl;
    
    
    
    cout << "Please enter the name of the file containing responses (including complete path): ";
    cin >> name_response;
    cout << endl;
        
    cout << "Please enter the name of the file containing covariates (excluding intercept in the file ; including complete path) ";
    cin >> name_covariate;
    cout << endl;
    
    cout << "Please enter the name of the file containing **C transpose** in hypothesis testing C'b = 0 (including intercept in the first column in C'; including complete path) ";
    cin >> name_waldC;
    cout << endl;


	cout << "Please enter the name of the file containing an indicator array which indicates the basis column for C transpose (including intercept)";
    cin >> name_waldC_basis;
    cout << endl;
    
    
    cout << "Please enter the intended dimension after projecton: ";
    cin >> projection_dim;
    cout << endl;
	
    
    
    
    
    ////////// file reading /////////////
    
    
    ifstream input_response,
             input_covariate,
             input_waldC,
			 input_waldC_basis
             ;
    
    input_response.open(name_response);
    input_covariate.open(name_covariate);
    input_waldC.open(name_waldC);
	input_waldC_basis.open(name_waldC_basis);
	
    
    
    if(!input_response.good()) 
        cout << "The response file does not exist!!" <<endl;
    
    if(!input_covariate.good()) 
        cout << "The covariate file does not exist!!" <<endl;
    
    if(!input_waldC.good()) 
        cout << "The C matrix transpose of wald test file does not exist!!" <<endl;

	if(!input_waldC_basis.good()) 
        cout << "The indicator array of wald test basis file does not exist!!" <<endl;
    
    
    
    if(!input_response.good() || !input_covariate.good() || !input_waldC.good() ||!input_waldC_basis.good() )
        exit(5); // if one of the input file does not exist then break from the program


            
    
    
    double** all_response = dmatrix(1,num_subject,1,num_response);
    double** all_covariate = dmatrix(1,num_subject,1,num_covariate);
    double** waldC_trans = dmatrix(1, wald_df, 1, num_covariate + 1); // C' in the hypothesis testing
	double* waldC_trans_basis = dvector(1, num_covariate + 1); 
		    ///// specify which column is a basis of column space of waldC_trans by 1(yes) or 0(no)



    
    int dss, drr, dcc, dww; // indices for each numbers (subjects, response, covariates and wald test respectively)
    
    for (dss=1;dss<=num_subject;dss++)
        {
        
        for(drr=1;drr<=num_response;drr++)  
            input_response >> all_response[dss][drr];
            
        for(dcc=1;dcc<=num_covariate;dcc++)  
            input_covariate >> all_covariate[dss][dcc];    
            
         }
    
    
    
    for(dww = 1; dww <= wald_df; dww++ )
        for(dcc = 1; dcc<= num_covariate + 1; dcc++)
            input_waldC >> waldC_trans[dww][dcc];


		for(int dii = 1; dii <= num_covariate + 1; dii++)
			input_waldC_basis >> waldC_trans_basis[dii];
		
        
    
    input_response.close();
    input_covariate.close();
    input_waldC.close();
	input_waldC_basis.close();
    
    
       
    
    


    
/********************* file output setting *********************/   
    
    ofstream output_summary;
    
    output_summary.open("/Users/Joanne/Desktop/output.summary");
    
    
       
    
/********************* Wildbootstrap Set up *********************/
    
       
    
    
    //////////// Number of Wild bootstrap input///////////
    int g;
    cout << "Please enter the number of times running wild bootstrap" << endl;
    cout << "(must be an positive integer): " << endl;
    cin >> g;
    
    
    
   
/********************* Bagging Procedure for all snps*********************/
    
    
    ////// random number initialization //////
    int seed, SEEDY[12];
    seed=17;
    setSEED(SEEDY, seed);
    init1(SEEDY);
    
        
      /********************* wild boostrap and testing statistics set up *********************/ 
		
		double* distribution_tbar = dvector(1, g); // distribution of tbar
        
        double* zobs = dvector(1,1);
                
        zobs[1] = 0.0;
    
 		
        
          /********************* Bagging Procedure for 1 snp*********************/ 
        
        Bagging(distribution_tbar, all_covariate, all_response, waldC_trans, num_response, num_subject, num_covariate, g, zobs, wald_df ,waldC_trans_basis, argv, projection_dim);
    
    
    
            
        /********************* Hypothesis Testing ***********************************/
        
    
    
        double sum = 0;
    
        for(int dii = 1; dii <= g; dii++)
            if(zobs[1] <= distribution_tbar[dii])
                sum = sum + 1;
    
        double p_value;
        double g_double;
    
        g_double = double(g);
       
        p_value = sum /g_double; 
		
        
        /// output ///
        output_summary << "The p-value is " << p_value << "." <<endl;
        output_summary << "The above results are based on number of wild bootstrap samples: " << g << "."<< endl;
        
        
        
        free_dvector(distribution_tbar, 1, g); 
        free_dvector(zobs, 1, 1);
    
    	free_dmatrix(all_response, 1, num_subject, 1, num_response);
        free_dmatrix(all_covariate, 1, num_subject, 1, num_covariate);
        free_dmatrix(waldC_trans, 1, wald_df, 1, num_covariate + 1);
		free_dvector(waldC_trans_basis, 1, num_covariate + 1);
    
    
    
    
    
    
    
    
    return 0;
}



