# include <cstdio>   
# include <cstdlib>  
# include <cmath>     
# include "nrutil.h"
# include "matrix_tool.h"
# include <iostream>
# include <string>
# include <fstream>



using namespace std;




extern char* outputDir;

void matrixmultiply (double **A, int row1,int column1,double **B, int row2,int column2,double **AB)
{
	int i,j,m;
    
	for (i=1;i<=row1;i++)
		for (j=1;j<=column2;j++)
			AB[i][j]=0;
    
	for (i=1;i<=row1;i++)
        for (j=1;j<=column2;j++)
            for (m=1;m<=column1;m++){
                AB[i][j]+=A[i][m]*B[m][j];
                }
}





void matrixtranspose(double **A,int row,int column, double **B)
{ 
	int i,j;
    for (i=1;i<=column;i++)
		for (j=1;j<=row;j++)
			B[i][j]=0;
    
    for  (i=1;i<=row;i++)
        for (j=1;j<=column;j++){
            B[j][i]=A[i][j];
            }
}



//// for matrix inversion ////
void ludcmp(double **a,int n,int *indx) 
{
	int i,imax,j,k;
	double big,dum,sum,temp;
	double *vv, TINY;
    
    TINY=1.0e-20;
	vv=dvector(1,n);
    //	*d=1.0;
	for (i=1;i<=n;i++) {
		big=0.0;
		for (j=1;j<=n;j++)
			if ((temp=fabs(a[i][j])) > big) big=temp;
		if (big == 0.0) nrerror("Sigmatrix in ludcmp") ;
		vv[i]=1.0/big;
	}
	for (j=1;j<=n;j++) {
		for (i=1;i<j;i++) {
			sum=a[i][j];
			for (k=1;k<i;k++) sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
		}
		big=0.0;
		for (i=j;i<=n;i++) {
			sum=a[i][j];
			for (k=1;k<j;k++)
				sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
			if ( (dum=vv[i]*fabs(sum)) >= big) {
				big=dum;
				imax=i;
			}
		}
		if (j != imax) {
			for (k=1;k<=n;k++) {
				dum=a[imax][k];
				a[imax][k]=a[j][k];
				a[j][k]=dum;
			}
            //			*d = -(*d);
			vv[imax]=vv[j];
		}
		indx[j]=imax;
		if (a[j][j] == 0.0) a[j][j]=TINY;
		if (j != n) {
			dum=1.0/(a[j][j]);
			for (i=j+1;i<=n;i++) a[i][j] *= dum;
		}
	}
	free_dvector(vv,1,n);
}



//// for matrix inversion ////
void lubksb(double **a, int n, int *indx, double *b)
{
	int i,ii=0,ip,j;
	double sum;
    
    for (i=1;i<=n;i++) {
		ip=indx[i];
		sum=b[ip];
		b[ip]=b[i];
		if (ii)
			for (j=ii;j<=i-1;j++)
                sum -= a[i][j]*b[j];
		else if (sum) ii=i;
		b[i]=sum;
	}
	for (i=n;i>=1;i--) {
		sum=b[i];
		for (j=i+1;j<=n;j++) sum -= a[i][j]*b[j];
		b[i]=sum/a[i][i];
	}
}



////// invert a matrix //////////
void invv(double **fma, int nn)  /* any nn x nn matrix's inverse */ 
{
	int  i, j, k, *indx;
	double *COL, **ipi;
    
	indx=ivector(1, nn); 	COL=dvector(1, nn); 	ipi=dmatrix(1, nn, 1, nn);
    
	ludcmp(fma, nn, indx);	
	for(i=1; i<=nn; i++){
		for(j=1; j<=nn; j++) COL[j]=0.0;
		COL[i]=1.0;		
		lubksb(fma, nn, indx, COL); 		
		for(j=1; j<=nn; j++) ipi[j][i]=COL[j];
	}
	for(k=1; k<=nn; k++)
		for(i=1; i<=nn; i++) fma[k][i]=ipi[k][i];
    
	free_ivector(indx, 1, nn);	free_dvector(COL, 1, nn);	free_dmatrix(ipi, 1, nn, 1, nn);
}   /* end of invv.c */ 





////////// cholesky decomposition for a positive definite matrix /////////

void choldc (double **a, int n, double* p)
{
    
    int i,j,k;
    double sum;
    
    for(i=1; i<=n; i++){
        for(j=i; j<=n;j++){
            for(sum=a[i][j], k=i-1; k>=1; k--)  sum-=a[i][k]*a[j][k];
            if (i==j){
                if(sum<=0.0)
                {
                 cout << "cholesky decomposition failed" << endl;
                 cout << "sum is " << sum << ", i is " << i << " and j is " << j << endl;  
                }
                p[i]=sqrt(sum);
            } else a[j][i]=sum/p[i];
        }
    }
}




////////////// SVD decomposition //////////////

double   pythag(double a, double b)
{
    double absa,absb;
    
    absa=fabs(a);
    absb=fabs(b);
    if (absa > absb) 
        return absa*sqrt(1.0+SQR(absb/absa));
    else 
        return (absb == 0.0 ? 0.0 : absb*sqrt(1.0+SQR(absa/absb)));
}/* end */ 


void svdcmp(double **a,int m,int n,double *w, double **v)
{
	int flag,i,its,j,jj,k,l,nm;
	double c,f,h,s,x,y,z;
	double anorm=0.0,g=0.0,scale=0.0;
	double *rv1;
    
	if (m < n) nrerror("SVDCMP: You must augment A with extra zero rows");
	rv1=dvector(1,n);
	for (i=1;i<=n;i++) {
		l=i+1;
		rv1[i]=scale*g;
		g=s=scale=0.0;
		if (i <= m) {
			for (k=i;k<=m;k++) scale += fabs(a[k][i]);
			if (scale) {
				for (k=i;k<=m;k++) {
					a[k][i] /= scale;
					s += a[k][i]*a[k][i];
				}
				f=a[i][i];
				g = -SIGN(sqrt(s),f);
				h=f*g-s;
				a[i][i]=f-g;
				if (i != n) {
					for (j=l;j<=n;j++) {
						for (s=0.0,k=i;k<=m;k++) s += a[k][i]*a[k][j];
						f=s/h;
						for (k=i;k<=m;k++) a[k][j] += f*a[k][i];
					}
				}
				for (k=i;k<=m;k++) a[k][i] *= scale;
			}
		}
		w[i]=scale*g;
		g=s=scale=0.0;
		if (i <= m && i != n) {
			for (k=l;k<=n;k++) scale += fabs(a[i][k]);
			if (scale) {
				for (k=l;k<=n;k++) {
					a[i][k] /= scale;
					s += a[i][k]*a[i][k];
				}
				f=a[i][l];
				g = -SIGN(sqrt(s),f);
				h=f*g-s;
				a[i][l]=f-g;
				for (k=l;k<=n;k++) rv1[k]=a[i][k]/h;
				if (i != m) {
					for (j=l;j<=m;j++) {
						for (s=0.0,k=l;k<=n;k++) s += a[j][k]*a[i][k];
						for (k=l;k<=n;k++) a[j][k] += s*rv1[k];
					}
				}
				for (k=l;k<=n;k++) a[i][k] *= scale;
			}
		}
		anorm=MAX(anorm,(fabs(w[i])+fabs(rv1[i])));
	}
	for (i=n;i>=1;i--) {
		if (i < n) {
			if (g) {
				for (j=l;j<=n;j++)
					v[j][i]=(a[i][j]/a[i][l])/g;
				for (j=l;j<=n;j++) {
					for (s=0.0,k=l;k<=n;k++) s += a[i][k]*v[k][j];
					for (k=l;k<=n;k++) v[k][j] += s*v[k][i];
				}
			}
			for (j=l;j<=n;j++) v[i][j]=v[j][i]=0.0;
		}
		v[i][i]=1.0;
		g=rv1[i];
		l=i;
	}
	for (i=n;i>=1;i--) {
		l=i+1;
		g=w[i];
		if (i < n)
			for (j=l;j<=n;j++) a[i][j]=0.0;
		if (g) {
			g=1.0/g;
			if (i != n) {
				for (j=l;j<=n;j++) {
					for (s=0.0,k=l;k<=m;k++) s += a[k][i]*a[k][j];
					f=(s/a[i][i])*g;
					for (k=i;k<=m;k++) a[k][j] += f*a[k][i];
				}
			}
			for (j=i;j<=m;j++) a[j][i] *= g;
		} else {
			for (j=i;j<=m;j++) a[j][i]=0.0;
		}
		++a[i][i];
	}
	for (k=n;k>=1;k--) {
		for (its=1;its<=50;its++) {
			flag=1;
			for (l=k;l>=1;l--) {
				nm=l-1;
				if (fabs(rv1[l])+anorm == anorm) {
					flag=0;
					break;
				}
				if (fabs(w[nm])+anorm == anorm) break;
			}
			if (flag) {
				c=0.0;
				s=1.0;
				for (i=l;i<=k;i++) {
					f=s*rv1[i];
					if (fabs(f)+anorm != anorm) {
						g=w[i];
						h=pythag(f,g);
						w[i]=h;
						h=1.0/h;
						c=g*h;
						s=(-f*h);
						for (j=1;j<=m;j++) {
							y=a[j][nm];
							z=a[j][i];
							a[j][nm]=y*c+z*s;
							a[j][i]=z*c-y*s;
						}
					}
				}
			}
			z=w[k];
			if (l == k) {
				if (z < 0.0) {
					w[k] = -z;
					for (j=1;j<=n;j++) v[j][k]=(-v[j][k]);
				}
				break;
			}
            //			if (its == 30) nrerror("No convergence in 30 SVDCMP iterations");
			x=w[l];
			nm=k-1;
			y=w[nm];
			g=rv1[nm];
			h=rv1[k];
			f=((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
			g=pythag(f,1.0);
			f=((x-z)*(x+z)+h*((y/(f+SIGN(g,f)))-h))/x;
			c=s=1.0;
			for (j=l;j<=nm;j++) {
				i=j+1;
				g=rv1[i];
				y=w[i];
				h=s*g;
				g=c*g;
				z=pythag(f,h);
				rv1[j]=z;
				c=f/z;
				s=h/z;
				f=x*c+g*s;
				g=g*c-x*s;
				h=y*s;
				y=y*c;
				for (jj=1;jj<=n;jj++) {
					x=v[jj][j];
					z=v[jj][i];
					v[jj][j]=x*c+z*s;
					v[jj][i]=z*c-x*s;
				}
				z=pythag(f,h);
				w[j]=z;
				if (z) {
					z=1.0/z;
					c=f*z;
					s=h*z;
				}
				f=(c*g)+(s*y);
				x=(c*y)-(s*g);
				for (jj=1;jj<=m;jj++) {
					y=a[jj][j];
					z=a[jj][i];
					a[jj][j]=y*c+z*s;
					a[jj][i]=z*c-y*s;
				}
			}
			rv1[l]=0.0;
			rv1[k]=f;
			w[k]=x;
		}
	}
	free_dvector(rv1,1,n);
}

