#ifndef MATRIX_TOOL_H
#define MATRIX_TOOL_H

# include <iostream>
# include <string>
# include <fstream>

#define MAX(a,b) ((a) > (b) ? (a) : (b))
 
 
using namespace std;

/* variance component model */
void ludcmp(double **a,int n,int *indx); 
void lubksb(double **a, int n, int *indx, double *b);

/* tool functions */
double   pythag(double a, double b);

/* matrix computation tools */
void matrixmultiply (double **A, int row1,int column1,double **B, int row2,int column2,double **AB);
void matrixtranspose(double **A,int row,int column, double **B);
void invv(double **fma, int nn); 


/* matrix decomposition */
void choldc (double **a, int n, double* p); // cholesky decomposition 
void svdcmp(double **a,int m,int n,double *w, double **v); // SVD decomposition

#endif
