#ifndef NRUTIL_H
#define NRUTIL_H

#ifdef __STDC__
#define PI 3.1415926f
#else
#define PI 3.1415926
#endif

 

static float sqrarg;
#define SQR(a) ((sqrarg=(a)) == 0.0 ? 0.0 : sqrarg*sqrarg)

/*
static double dsqrarg;
#define DSQR(a) ((dsqrarg=(a)) == 0.0 ? 0.0 : dsqrarg*dsqrarg)
static double dmaxarg1,dmaxarg2;
#define DMAX(a,b) (dmaxarg1=(a),dmaxarg2=(b),(dmaxarg1) > (dmaxarg2) ?\
(dmaxarg1) : (dmaxarg2))
static double dminarg1,dminarg2;
#define DMIN(a,b) (dminarg1=(a),dminarg2=(b),(dminarg1) < (dminarg2) ?\
(dminarg1) : (dminarg2))
static float maxarg1,maxarg2;
#define FMAX(a,b) (maxarg1=(a),maxarg2=(b),(maxarg1) > (maxarg2) ?\
(maxarg1) : (maxarg2))
static float minarg1,minarg2;
#define FMIN(a,b) (minarg1=(a),minarg2=(b),(minarg1) < (minarg2) ?\
(minarg1) : (minarg2))
static int lmaxarg1,lmaxarg2;
#define LMAX(a,b) (lmaxarg1=(a),lmaxarg2=(b),(lmaxarg1) > (lmaxarg2) ?\
(lmaxarg1) : (lmaxarg2))
static int lminarg1,lminarg2;

#define LMIN(a,b) (lminarg1=(a),lminarg2=(b),(lminarg1) < (lminarg2) ?\
(lminarg1) : (lminarg2))
static int imaxarg1,imaxarg2;
#define IMAX(a,b) (imaxarg1=(a),imaxarg2=(b),(imaxarg1) > (imaxarg2) ?\
(imaxarg1) : (imaxarg2))
static int iminarg1,iminarg2;
#define IMIN(a,b) (iminarg1=(a),iminarg2=(b),(iminarg1) < (iminarg2) ?\
(iminarg1) : (iminarg2))
 */

#define SIGN(a,b) ((b) >= 0.0 ? fabs(a) : -fabs(a))



void nrerror(const char* error_text);
float *vector(int nl, int nh);
int *ivector(int nl, int nh);
unsigned char *cvector(int nl, int nh);
unsigned long *lvector(int nl, int nh);
long *iarray(int nl, int nh);
double *dvector(int nl, int nh);
float **matrix(int nrl, int nrh, int ncl, int nch);
double **dmatrix(int nrl, int nrh, int ncl, int nch);
int **imatrix(int nrl, int nrh, int ncl, int nch);
float **submatrix(float **a, int oldrl, int oldrh, int oldcl, int oldch,
int newrl, int newcl);
float **convert_matrix(float *a, int nrl, int nrh, int ncl, int nch);
float ***f3tensor(int nrl, int nrh, int ncl, int nch, int ndl, int ndh);
float ***fmatrix3(int nrl, int nrh, int ncl, int nch, int n3l, int n3h);
float ****fmatrix4(int nrl, int nrh, int ncl, int nch, int n3l, int n3h, int n4l, int n4h);
float***** matrix5f(int n1, int n2, int n3, int n4, int n5);


void free_vector(float *v, int nl, int nh);
void free_ivector(int *v, int nl, int nh);
void free_cvector(unsigned char *v, int nl, int nh);
void free_lvector(unsigned long *v, int nl, int nh);
void free_iarray(long *v, int nl, int nh);
void free_dvector(double *v, int nl, int nh);
void free_matrix(float **m, int nrl, int nrh, int ncl, int nch);
void free_dmatrix(double **m, int nrl, int nrh, int ncl, int nch);
void free_imatrix(int **m, int nrl, int nrh, int ncl, int nch);
void free_submatrix(float **b, int nrl, int nrh, int ncl, int nch);
void free_convert_matrix(float **b, int nrl, int nrh, int ncl, int nch);
void free_f3tensor(float ***t, int nrl, int nrh, int ncl, int nch,
int ndl, int ndh);
void free_dmatrix3(); 
void free_fmatrix3(float ***m, int nrl, int nrh, int ncl, int nch, int n3l, int n3h); 
void free_fmatrix4(float ****m,int nrl, int nrh, int ncl, int nch, int n3l, int n3h, int n4l, int n4h) ;
void free_fmatrix5(float *****m,int nrl, int nrh, int ncl, int nch, int n3l, int n3h, int n4l, int n4h, int n5l, int n5h);
unsigned short *usvector(int nl, int nh);
void free_usvector();

 

  
#endif 


