library(elasticnet)

#setwd("/Users/Joanne/Desktop/MultipleTrait_MultipleCovariate_SimType2/build/Debug/")

intput_covariance_matrix = "input_covariance.txt"

output_sparse_matrix = "output.txt"

########### reading P #############

P = read.table(intput_covariance_matrix,header=FALSE)

P = as.matrix(P)



############## penalty parameter setting ##############

lambda_2 = c(0,1e-9,1e-8,1e-7,1e-6,1e-5,1e-4,1e-3,1e-2,1e-1)
lambda_1 = c(0,1e-9,1e-8,1e-7,1e-6,1e-5,1e-4,1e-3,1e-2,1e-1,1,5,10,100)

length_l2 = length(lambda_2)
length_l1 = length(lambda_1)


################# bic matrix ###################


bic = matrix(rep(0,length_l2*length_l1),ncol=length_l1)



#################### calculate bic for each combination of lambda1 and lambda 2################


for(dl2 in 1:length_l2)
	for(dl1 in 1:length_l1)
#for(dl2 in 1:1)
#	for(dl1 in 1:length_l1)
{
	
spca_result = spca(P,K=1,para=c(lambda_1[dl1]),type="Gram",sparse="penalty",use.corr=FALSE,lambda=lambda_2[dl2],max.iter=200,trace=FALSE,eps.conv=1e-3)	
	

loading = as.matrix(spca_result$loading)
temp = P %*% loading ## P %*% B
temp_svd = svd(temp)	
a = temp_svd$u %*% t(temp_svd$v)


### df for lambda_1[dl1]
non_zero = 0
for(dii in 1:length(P[,1]))
if(loading[dii,1] != 0)
	non_zero = non_zero + 1


	
bic[dl2,dl1] = t(a[,1]-loading[,1]) %*% P %*% (a[,1]- loading[,1]) + non_zero * log(length(P[,1]))/length(P[,1])

if (non_zero == 0)
	bic[dl2,dl1] = 1000



#print(dl2)
#print(dl1)
#print(bic[dl2,dl1])
	
	
rm(list="spca_result")	
rm(list="loading")	
rm(list="temp")
rm(list="non_zero")
rm(list="temp_svd")
rm(list="a")
	
}##### loop for dl2 && dl1





min_bic = min(bic)


for(dl2 in 1:length_l2)
	for(dl1 in 1:length_l1)
		if(bic[dl2,dl1] == min_bic)
			{
			lambda2 = lambda_2[dl2]
			lambda1 = lambda_1[dl1]
			}
	

spca_result = spca(P,K=1,para=c(lambda1),type="Gram",sparse="penalty",use.corr=FALSE,lambda=lambda2,max.iter=200,trace=FALSE,eps.conv=1e-3)	


loading = spca_result$loading



write.table(loading,output_sparse_matrix,row.names = FALSE, col.names = FALSE)


rm(list="P")
rm(list="loading")
rm(list="lambda_2")
rm(list="lambda_1")
rm(list="length_l2")
rm(list="length_l1")
rm(list="bic")
rm(list="lambda1")
rm(list="lambda2")
rm(list="min_bic")
rm(list="spca_result")