#ifndef STAT_TOOL_H
#define STAT_TOOL_H

# include <iostream>
# include <string>
# include <fstream>

using namespace std;


#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);
#define SHFT2(a,b,c) (a)=(b);(b)=(c);
#define SHFT3(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);
#define SWAP(a,b) {double temp=(a);(a)=(b);(b)=temp;}

# define   NMAX 100    /* this constant is used in iv.c */ 
# define   Nresample 1000    
# define   Nsimulation 1 



extern unsigned int congrval,tausval;




////// general tool ///////
double mean(double* vector, int length_vector);//mean for a double vector
double variance(double* vector, int length_vector); // variance for a double vector
int factorial(int n);






/////// random number generator ///////
void    init1(int seeds[]);
double  s_xuni(void);
void    setSEED(int Y [],int SEED);
void    set_seed(void); 
void    outputSeed(void); 





////// generalized version to multiple covariate of estimation in Klei2008's paper //////
void covariance_VQ(double** response, double** covariate, 
                   int num_subject, int num_response, int num_covariate, double** VQ,
                   double** waldC_trans, int wald_df); // VQ

void covariance_VR(double** response, double** covariate, 
                   int num_subject, int num_response, int num_covariate, double** VR); //VR

double test_stat(double** w0y, double** covariate, int num_subject, int num_covariate,double** waldC_trans, int wald_df, int projection_dim);// testing statistics

double test_stat_wildb(double** y, double** covariate, int num_subject, int num_covariate,double** waldC_trans, int wald_df, double* epsilon_star);
		// testing statistics under null hypothesis from wild bootstrap

void screening(double** response, double** covariate,double* response_pvalue,int num_response,int num_subject, int num_covariate, int wald_df, double** waldC_trans);


void wildb_sample_generating(double* epsilon_star, double** all_response, double** covariate, int num_subject, int num_covariate, int num_response, double** wildb_response, double** waldC_trans, int wald_df);

void sparse_pca(float* spca_conv,double** P,int num_effect_response_int,double* eigenvector);


#endif



