# include <stdio.h>   
# include <stdlib.h>  
# include "math.h"    
# include "nrutil.h"
# include "MASALallfile.h"
# include <iostream>
# include <string>
# include <fstream>
//# include <windows.h>
 


using namespace std;

double pythag(double a, double b)
{
double absa,absb;
 absa=fabs(a);
 absb=fabs(b);
if (absa > absb) return absa*sqrt(1.0+SQR(absb/absa));
else return (absb == 0.0 ? 0.0 : absb*sqrt(1.0+SQR(absa/absb)));

}


void svdcmp(double **a,int m,int n,double *w,double **v)
{
	int flag,i,its,j,jj,k,l,nm;
	double c,f,h,s,x,y,z;
	double anorm=0.0,g=0.0,scale=0.0;
	double *rv1;
 
	if (m < n) nrerror("SVDCMP: You must augment A with extra zero rows");
	rv1=dvector(1,n);
	for (i=1;i<=n;i++) {
		l=i+1;
		rv1[i]=scale*g;
		g=s=scale=0.0;
		if (i <= m) {
			for (k=i;k<=m;k++) scale += fabs(a[k][i]);
			if (scale) {
				for (k=i;k<=m;k++) {
					a[k][i] /= scale;
					s += a[k][i]*a[k][i];
				}
				f=a[i][i];
				g = -SIGN(sqrt(s),f);
				h=f*g-s;
				a[i][i]=f-g;
				if (i != n) {
					for (j=l;j<=n;j++) {
						for (s=0.0,k=i;k<=m;k++) s += a[k][i]*a[k][j];
						f=s/h;
						for (k=i;k<=m;k++) a[k][j] += f*a[k][i];
					}
				}
				for (k=i;k<=m;k++) a[k][i] *= scale;
			}
		}
		w[i]=scale*g;
		g=s=scale=0.0;
		if (i <= m && i != n) {
			for (k=l;k<=n;k++) scale += fabs(a[i][k]);
			if (scale) {
				for (k=l;k<=n;k++) {
					a[i][k] /= scale;
					s += a[i][k]*a[i][k];
				}
				f=a[i][l];
				g = -SIGN(sqrt(s),f);
				h=f*g-s;
				a[i][l]=f-g;
				for (k=l;k<=n;k++) rv1[k]=a[i][k]/h;
				if (i != m) {
					for (j=l;j<=m;j++) {
						for (s=0.0,k=l;k<=n;k++) s += a[j][k]*a[i][k];
						for (k=l;k<=n;k++) a[j][k] += s*rv1[k];
					}
				}
				for (k=l;k<=n;k++) a[i][k] *= scale;
			}
		}
		anorm=MAX(anorm,(fabs(w[i])+fabs(rv1[i])));
	}
	for (i=n;i>=1;i--) {
		if (i < n) {
			if (g) {
				for (j=l;j<=n;j++)
					v[j][i]=(a[i][j]/a[i][l])/g;
				for (j=l;j<=n;j++) {
					for (s=0.0,k=l;k<=n;k++) s += a[i][k]*v[k][j];
					for (k=l;k<=n;k++) v[k][j] += s*v[k][i];
				}
			}
			for (j=l;j<=n;j++) v[i][j]=v[j][i]=0.0;
		}
		v[i][i]=1.0;
		g=rv1[i];
		l=i;
	}
	for (i=n;i>=1;i--) {
		l=i+1;
		g=w[i];
		if (i < n)
			for (j=l;j<=n;j++) a[i][j]=0.0;
		if (g) {
			g=1.0/g;
			if (i != n) {
				for (j=l;j<=n;j++) {
					for (s=0.0,k=l;k<=m;k++) s += a[k][i]*a[k][j];
					f=(s/a[i][i])*g;
					for (k=i;k<=m;k++) a[k][j] += f*a[k][i];
				}
			}
			for (j=i;j<=m;j++) a[j][i] *= g;
		} else {
			for (j=i;j<=m;j++) a[j][i]=0.0;
		}
		++a[i][i];
	}
	for (k=n;k>=1;k--) {
		for (its=1;its<=50;its++) {
			flag=1;
			for (l=k;l>=1;l--) {
				nm=l-1;
				if (fabs(rv1[l])+anorm == anorm) {
					flag=0;
					break;
				}
				if (fabs(w[nm])+anorm == anorm) break;
			}
			if (flag) {
				c=0.0;
				s=1.0;
				for (i=l;i<=k;i++) {
					f=s*rv1[i];
					if (fabs(f)+anorm != anorm) {
						g=w[i];
						h=pythag(f,g);
						w[i]=h;
						h=1.0/h;
						c=g*h;
						s=(-f*h);
						for (j=1;j<=m;j++) {
							y=a[j][nm];
							z=a[j][i];
							a[j][nm]=y*c+z*s;
							a[j][i]=z*c-y*s;
						}
					}
				}
			}
			z=w[k];
			if (l == k) {
				if (z < 0.0) {
					w[k] = -z;
					for (j=1;j<=n;j++) v[j][k]=(-v[j][k]);
				}
				break;
			}
//			if (its == 30) nrerror("No convergence in 30 SVDCMP iterations");
			x=w[l];
			nm=k-1;
			y=w[nm];
			g=rv1[nm];
			h=rv1[k];
			f=((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
			g=pythag(f,1.0);
			f=((x-z)*(x+z)+h*((y/(f+SIGN(g,f)))-h))/x;
			c=s=1.0;
			for (j=l;j<=nm;j++) {
				i=j+1;
				g=rv1[i];
				y=w[i];
				h=s*g;
				g=c*g;
				z=pythag(f,h);
				rv1[j]=z;
				c=f/z;
				s=h/z;
				f=x*c+g*s;
				g=g*c-x*s;
				h=y*s;
				y=y*c;
				for (jj=1;jj<=n;jj++) {
					x=v[jj][j];
					z=v[jj][i];
					v[jj][j]=x*c+z*s;
					v[jj][i]=z*c-x*s;
				}
				z=pythag(f,h);
				w[j]=z;
				if (z) {
					z=1.0/z;
					c=f*z;
					s=h*z;
				}
				f=(c*g)+(s*y);
				x=(c*y)-(s*g);
				for (jj=1;jj<=m;jj++) {
					y=a[jj][j];
					z=a[jj][i];
					a[jj][j]=y*c+z*s;
					a[jj][i]=z*c-y*s;
				}
			}
			rv1[l]=0.0;
			rv1[k]=f;
			w[k]=x;
		}
	}
	free_dvector(rv1,1,n);
}


double gammln(double xx)
{
	double x,tmp,ser;
	static double cof[6]={76.18009173,-86.50532033,24.01409822,
		-1.231739516,0.120858003e-2,-0.536382e-5};
	int j;

	x=xx-1.0;
	tmp=x+5.5;
	tmp -= (x+0.5)*log(tmp);
	ser=1.0;
	for (j=0;j<=5;j++) {
		x += 1.0;
		ser += cof[j]/x;
	}
	return -tmp+log(2.50662827465*ser);
}/*  gammln */ 



double betai(double a, double b, double x)
{
	double bt;
 
	 
	if (x < 0.0 || x > 1.0) 
		nrerror("Bad x in routine BETAI");
	if (x == 0.0 || x == 1.0) bt=0.0;
	else
		bt=gammln(a+b)-gammln(a)-gammln(b)+a*log(x)+b*log(1.0-x);
 	if (x < (a+1.0)/(a+b+2.0))
		return exp(bt)*betacf(a,b,x)/a;
	else
		return 1.0-exp(bt)*betacf(b,a,1.0-x)/b;
}/* betai */ 


double  betacf(double a,double b,double x)
{

    double aa,c,d,del,h,qab,qam,qap;
    double epSilon=3.0e-7; 
	int m, m2, NitMax=100; 
    double FPMIN=1.0e-30;

	qab=a+b;
	qap=a+1.0;
	qam=a-1.0;
	c=1.0;  
    d=1.0-qab*x/qap;
	if (fabs(d) < FPMIN) d=FPMIN;
    d=1.0/d;
    h=d;
    for (m=1;m<=NitMax;m++) {
		m2=2*m;
		aa=m*(b-m)*x/((qam+m2)*(a+m2));
		d=1.0+aa*d;  
		if (fabs(d) < FPMIN) d=FPMIN;
		c=1.0+aa/c;
		if (fabs(c) < FPMIN) c=FPMIN;
		d=1.0/d;
		h *= d*c;
		aa = -(a+m)*(qab+m)*x/((a+m2)*(qap+m2));
		d=1.0+aa*d;  
		if (fabs(d) < FPMIN) d=FPMIN;
		c=1.0+aa/c;
		if (fabs(c) < FPMIN) c=FPMIN;
		d=1.0/d;
		del=d*c;
		h *= del;
		if (fabs(del-1.0) < epSilon) break;  
//		printf("%14lf ", h); 
		}
    if (m > NitMax) 
        nrerror("a or b too big, or MAXIT too small in betacf");
    return h;

}/*betacf*/ 
  





 
void linear(int Ncov, int TotalImg, double *beta,  float *residual, double **designXX,   double **TXX, double *response)  
{
	int dii, djj, dkk;
	double  *XTY; 
    double SSE; 

	XTY=dvector(1, Ncov); 
   
	for(dii=1; dii<=Ncov; dii++){
		XTY[dii]=0.0;
		for(dkk=1; dkk<=TotalImg; dkk++)
            XTY[dii]+=designXX[dkk][dii]*response[dkk]; 
	}

	for(dii=1; dii<=Ncov; dii++){
	    beta[dii]=0.0;
		for(djj=1; djj<=Ncov; djj++)
            beta[dii]+=TXX[dii][djj]*XTY[djj]; 
	}

	SSE=0.0;
	for(dii=1; dii<=TotalImg; dii++)
		SSE+=response[dii]*response[dii];
    for(dii=1; dii<=Ncov; dii++)
	    SSE-=beta[dii]*XTY[dii]; 

	for(dii=1; dii<=TotalImg; dii++){
        residual[dii]=response[dii];
		for(dkk=1; dkk<=Ncov; dkk++)
			residual[dii]-=designXX[dii][dkk]*beta[dkk]; 
	}
    beta[Ncov+1]=SSE; 

    free_dvector(XTY, 1, Ncov);
	

}/* end */ 

 void sort2(int n, double arr[])
{
int i,ir=n,j,k,l=1,*istack;
int M=7, NSTACK=50; 
int jstack=0;
double a;
 
	istack=ivector(1,NSTACK);
	for (;;) { 
	 if (ir-l < M) {
	   for (j=l+1;j<=ir;j++) {
			a=arr[j];
			for (i=j-1;i>=l;i--) {
				if (arr[i] <= a) break;
					arr[i+1]=arr[i];
			}
			arr[i+1]=a;
		}
	if (!jstack) {
		free_ivector(istack,1,NSTACK);
	return;
	}
	ir=istack[jstack];  
	l=istack[jstack-1];
	jstack -= 2;
	} else {
		k=(l+ir) >> 1;  
		SWAP(arr[k],arr[l+1])
		if (arr[l] > arr[ir]) {
			SWAP(arr[l],arr[ir])
		}
		if (arr[l+1] > arr[ir]) {
			SWAP(arr[l+1],arr[ir])
	}
		if (arr[l] > arr[l+1]) {
			SWAP(arr[l],arr[l+1])
		}
		i=l+1;  
		j=ir;
		a=arr[l+1];  
		for (;;) {  
			do i++; while (arr[i] < a);  
			do j--; while (arr[j] > a);  
			if (j < i) break; 
				SWAP(arr[i],arr[j])  
		} 
		arr[l+1]=arr[j];  
		arr[j]=a;
		jstack += 2;
		if (jstack > NSTACK) nrerror("NSTACK too small in sort2.");
		if (ir-i+1 >= j-l) {
			istack[jstack]=ir;
			istack[jstack-1]=i;
			ir=j-1;
		} else {
			istack[jstack]=j-1;
			istack[jstack-1]=l;
			l=i;
		}
	}
	}
}/* sort2 */ 


  

void sort3(int n,double ra[],double rb[],double rc[])
{
	int j,*iwksp;
	double *wksp;
 

	iwksp=ivector(1,n);
	wksp=dvector(1,n);
	indexx(n,ra,iwksp);
	for (j=1;j<=n;j++) wksp[j]=ra[j];
	for (j=1;j<=n;j++) ra[j]=wksp[iwksp[j]];
	for (j=1;j<=n;j++) wksp[j]=rb[j];
	for (j=1;j<=n;j++) rb[j]=wksp[iwksp[j]];
	for (j=1;j<=n;j++) wksp[j]=rc[j];
	for (j=1;j<=n;j++) rc[j]=wksp[iwksp[j]];
	free_dvector(wksp,1,n);
	free_ivector(iwksp,1,n);
}/* end */ 


void indexx(int n,double arrin[],int indx[])
{
	int l,j,ir,indxt,i;
	double q;

	for (j=1;j<=n;j++) indx[j]=j;
	l=(n >> 1) + 1;
	ir=n;
	for (;;) {
		if (l > 1)
			q=arrin[(indxt=indx[--l])];
		else {
			q=arrin[(indxt=indx[ir])];
			indx[ir]=indx[1];
			if (--ir == 1) {
				indx[1]=indxt;
				return;
			}
		}
		i=l;
		j=l << 1;
		while (j <= ir) {
			if (j < ir && arrin[indx[j]] < arrin[indx[j+1]]) j++;
			if (q < arrin[indx[j]]) {
				indx[i]=indx[j];
				j += (i=j);
			}
			else j=ir+1;
		}
		indx[i]=indxt;
	}
}/* end */ 




int chod(double **a, int n, double p[])
{

   int i,j,k;
   double   sum;

   for(i=1; i<=n; i++){
	for(j=i; j<=n;j++){
	   for(sum=a[i][j], k=i-1; k>=1; k--)  sum-=a[i][k]*a[j][k];
	   if (i==j){
	       if(sum<=0.0)
		     return(1);
	      p[i]=sqrt(sum);
	  } else a[j][i]=sum/p[i];
	 }
      }
   return(0);
  }





 
 

// Main programs to generate random numbers //   


double onetn(double as)
{
double aa, rz, zz, uu, vv;
int flag=0;

  if(as>=0.0)
    while(flag==0)
     { 
     aa=0.5*as+0.5*sqrt(as*as+4.0);
     zz=expdev()/aa+as;
     rz=-(zz-aa)*(zz-aa)/2.0;
     // uu=rand()/(RAND_MAX+1.0);
	 uu=s_xuni(); 
     if(uu<=0.0) vv=uu;
     else  vv=log(uu);
     if(vv<=rz)  flag=1;
     }
     else 
       while(flag==0) 
          {
         //   idum=rand();
        //    zz=gasdev(&idum);
		   zz=gasdev();
           if(zz>as) flag=1;
          }

  return(zz); 
}/* onetn */ 

double expdev(void)
{
   
    double  dum;
      
     do 
        dum=s_xuni();
     while(dum==0.0); 
     return -log(dum);
}/* expdev */ 

double trunom(double as, double bl)
{
  double  rz, zz, uu, vv;
  int flag=0; 

 if(as>bl){  
   printf("as=%14f, bl=%14f\n", as, bl);
   printf("Error: as>bl\n"); 
   exit(1); 
 }
 if(bl>=8)  
    while(flag==0)
      {
       zz=onetn(as); 
       if(zz<= bl){ 
          flag=1;  
		  return(zz);  }
      }
 if(as<=-8) 
    while(flag==0)
      {
       zz=-1.0*onetn(-1.0*bl); 
       if(zz>as){ 
          flag=1; 
		  return(zz);  }
      }
 if(as>-8 && bl<8.0)
   while(flag==0)
   {
   //zz=as+(bl-as)*rand()/(RAND_MAX+1.0);
    zz=as+(bl-as)*s_xuni();   
    if(bl<0.0)
      rz=(bl*bl-zz*zz)/2.0;
    else
      if(as>0.0)  
		 rz=(as*as-zz*zz)/2.0;
      else   
		 rz=-zz*zz/2.0;
   //uu=rand()/(RAND_MAX+1.0);
    uu=s_xuni();
    if(uu<=0.0)  vv=0.0;
    else   vv=log(uu);
    if(vv<=rz){  
        flag=1;
        return(zz);
      }
   }  
   
}/* end */

 



double poidev(double xm)
{
	static double sq,alxm,g,oldm=(-1.0);
	double em,t,y, PI_value=3.14159265;

	if (xm < 12.0) {
		if (xm != oldm) {
			oldm=xm;
			g=exp(-xm);
		}
		em = -1;
		t=1.0;
		do {
			em += 1.0;
			t *= s_xuni();
		} while (t > g);
	} else {
		if (xm != oldm) {
			oldm=xm;
			sq=sqrt(2.0*xm);
			alxm=log(xm);
			g=xm*alxm-gammln(xm+1.0);
		}
		do {
			do {
				y=tan(PI_value*s_xuni());
				em=sq*y+xm;
			} while (em < 0.0);
			em=floor(em);
			t=0.9*(1.0+y*y)*exp(em*alxm-gammln(em+1.0)-g);
		} while (s_xuni() > t);
	}
	return em;
}

 

void iv(double **W, int NP)
{
       int  i, k;
       double XX[NMAX+1], PP[NMAX+1], COL[NMAX+1], WW[NMAX+1][NMAX+1];
       

       choldc(W, NP, PP);
       for(k=1;k<=NP;k++){
	    for(i=1;i<=NP;i++)
	       COL[i]=0.0;
	    COL[k]=1.0;
	    cholsl(W, NP, PP, COL, XX);
	    for(i=1; i<=NP; i++)  WW[i][k]=XX[i];
	  }
       for(k=1; k<=NP; k++)
 	    for(i=1; i<=NP; i++)
            W[k][i]=WW[k][i];
 }/* end of inver.c */ 


double gasdev(void)
 {
	static int iset=0;
	static double gset;
	double fac,r,v1,v2;

	if  (iset == 0) {
		do {
			v1=2.0*s_xuni()-1.0;
			v2=2.0*s_xuni()-1.0;
			r=v1*v1+v2*v2;
		} while (r >= 1.0||r==0.0);
		fac=sqrt(-2.0*log(r)/r);
		gset=v1*fac;
		iset=1;
		return v2*fac;
	} else {
		iset=0;
		return gset;
	}
}/* end */ 

double gamdev(int ia)
{
 	int j;
	double am,e,s,v1,v2,x,y;

	if (ia < 1){
		printf("Error in routine GAMDEV");
		exit(1);
	}
	if (ia < 6) {
		x=1.0;
		for (j=1;j<=ia;j++) x *= s_xuni();
		x = -log(x);
	} else {
		do {
			do {
				do {
//					v1=2.0*ran2(idum)-1.0;
//					v2=2.0*ran2(idum)-1.0;
					v1=2.0*s_xuni()-1.0;
					v2=2.0*s_xuni()-1.0;
				} while (v1*v1+v2*v2 > 1.0);
				y=v2/v1;
				am=ia-1;
				s=sqrt(2.0*am+1.0);
				x=s*y+am;
			} while (x <= 0.0);
			e=(1.0+y*y)*exp(am*log(x/am)-s*y);
		} while (s_xuni() > e);
	}
	return x;
}




void cholsl(double **a,int n,double p[],double b[],double x[])
  {
     int i, k;
     double sum;

     for (i=1; i<=n;i++){
	  for(sum=b[i], k=i-1; k>=1;k--)  sum-=a[i][k]*x[k];
	  x[i]=sum/p[i];
      }
      for (i=n; i>=1; i--){
	  for (sum=x[i], k=i+1; k<=n; k++)  sum-=a[k][i]*x[k];
	  x[i]=sum/p[i];
	  }
}


void choldc (double **a, int n, double p[])
{

   int i,j,k;
   double sum;

  for(i=1; i<=n; i++){
	 for(j=i; j<=n;j++){
	    for(sum=a[i][j], k=i-1; k>=1; k--)  sum-=a[i][k]*a[j][k];
	       if (i==j){
	         if(sum<=0.0)
		        printf(" choldc failed");
	         p[i]=sqrt(sum);
	  } else a[j][i]=sum/p[i];
	 }
   }
 }








/*S-PLUS pseudo-random number generator
This based on GeorgeMarsaglias Super-Duper package from about 1973. 
The generator produces a 32-bit integer whose top 31 bits are divided by 231 to 
produce a real number in [0; 1). The 32-bit integer is produced by a bitwise 
exclusive-or of two 32-bit integers produced by separate generators.
The current values of congrval and tausval are encoded in
the vector .Random.seed , a vector of 12 integers in the range 0, ..., 63. If x
represents .Random.seed, we have
	congrval = sum_{1, ...,6} (x_i) (2^{6(i-1)})
	tausval  = sum_{1, ...,6} (x_{i+6}) (2^{6(i-1)})
*/
void init1(int seeds[]){
	int i;
	int size=6;
	unsigned int ctmp,ttmp;
	ctmp=0;
	ttmp=0;
	for(i=0;i<6;i++){
		ctmp+=seeds[i]*((unsigned int)pow(2,6*i));
		ttmp+=seeds[i+6]*((unsigned int)pow(2,6*i));
	}
	congrval=ctmp;
	tausval=ttmp;
}

double s_xuni(void)
{
	unsigned int n, lambda = 69069, res;
	do {
		congrval = congrval * lambda;
		tausval ^= tausval >> 15;
		tausval ^= tausval << 17;
		n = tausval ^ congrval;
		res = (n>>1) & 017777777777;
	} while(res == 0);
	return (res / 2147483648.);
}

void setSEED(int Y [],int SEED){
	int X[]={21, 14, 49,0,1,2, 32, 22, 36, 23, 28,  3};
	int size=12;
	int i;
	unsigned int tmp=((SEED-1)%1024)*(int)pow(2,22);

	for(i=0;i<size;i++){
		Y[i]=X[i];
	}
	
	for(i=5;i>=3;i--){
		Y[i]=tmp/(int)pow(2,6*i);
		tmp-=Y[i]*(int)pow(2,6*i);
	}
}

void set_seed(void){
  int Y[12];
  int i;
  int test=1;
  unsigned int SEED;
  void init1(int seeds[]);
  void setSEED(int Y[], int);

  //test whether SEED.TXT file exist
  //if NO, use the default seed
  //  otherwise, read the seed from file 
  //             and check whether it's between 0 & 63
  FILE *fp=fopen("SEED.TXT","r");
  if(fp){
    for(i=0;i<12;i++){
      fscanf(fp,"%d",&Y[i]);
      if(Y[i]<0||Y[i]>64) {
	test=0;
	printf("Invalid Value! The range is between 0 and 63\n");
	break;
      }
    }
    fclose(fp);
  }else{
    test=0;
  }
  // use the default seeds 
  // either Y is not valid
  // or SEED.TXT doesn't exist
  if(test==0){
    SEED=rand();
    setSEED(Y,SEED);
  }
  init1(Y);
  //output results to file splus.txt
}

//output seed to SEED.TXT
void outputSeed(void){
	int i;
	int Y[12];
	unsigned int ctmp=congrval, ttmp=tausval;
	char *filenm=(char *)malloc(sizeof(char)*256);
	FILE *fout=fopen("SEED.TXT","w");
	//cout<<"congrval="<<congrval<<", tausval="<<tausval<<endl;
	for(i=5;i>=0;i--){
		Y[i]=ctmp/(int)pow(2,6*i);
		ctmp-=Y[i]*(int)pow(2,6*i);
	}
	for(i=11;i>=6;i--){
		Y[i]=ttmp/(int)pow(2,6*(i-6));
		ttmp-=Y[i]*(int)pow(2,6*(i-6));
	}
	
	for(i=0;i<12;i++){
		fprintf(fout," %d   ",Y[i]);
	}
	fclose(fout);
}




void beschb(double x, double *gam1, double *gam2, double *gampl, double *gammi)
{
double xx;
static double c1[] = {
  -1.142022680371168e0,6.5165112670737e-3,
  3.087090173086e-4,-3.4706269649e-6,6.9437664e-9,
  3.67795e-11,-1.356e-13};
static double c2[] = {
  1.843740587300905e0,-7.68528408447867e-2,
  1.2719271366546e-3,-4.9717367042e-6,-3.31261198e-8,
  2.423096e-10,-1.702e-13,-1.49e-15};
int NUSE1=7, NUSE2=8; 

  xx=8.0*x*x-1.0;  
  *gam1=chebev(-1.0,1.0,c1,NUSE1,xx);
  *gam2=chebev(-1.0,1.0,c2,NUSE2,xx);
  *gampl= *gam2-x*(*gam1);
  *gammi= *gam2+x*(*gam1);

}/*  end   */ 


 



void bessik(double x, double xnu, double *ri, double *rk, double *rip, double *rkp)
{
int i,l,nl;
double a,a1,b,c,d,del,del1,delh,dels,e,f,fact,fact2,ff,gam1,gam2,
gammi,gampl,h,p,pimu,q,q1,q2,qnew,ril,ril1,rimu,rip1,ripl,
ritemp,rk1,rkmu,rkmup,rktemp,s,sum,sum1,x2,xi,xi2,xmu,xmu2;
double EPS=1.0e-16, FPMIN=1.0e-30, XMIN=2.0;
int  MAXIT=10000; 
 
if (x <= 0.0 || xnu < 0.0) nrerror("bad arguments in bessik");
nl=(int)(xnu+0.5);  
xmu=xnu-nl;
xmu2=xmu*xmu;
xi=1.0/x;
xi2=2.0*xi;
h=xnu*xi; 
if (h < FPMIN) h=FPMIN;
b=xi2*xnu;
d=0.0;
c=h;
for (i=1;i<=MAXIT;i++) {
b += xi2;
d=1.0/(b+d);  
c=b+1.0/c;
del=c*d;
h=del*h;
if (fabs(del-1.0) < EPS) break;
}
if (i > MAXIT) nrerror("x too large in bessik; try asymptotic expansion");
ril=FPMIN;  
ripl=h*ril;
ril1=ril;  
rip1=ripl;
fact=xnu*xi;
for (l=nl;l>=1;l--) {
ritemp=fact*ril+ripl;
fact -= xi;
ripl=fact*ritemp+ril;
ril=ritemp;
}
f=ripl/ril;  
if (x < XMIN) {  
x2=0.5*x;
pimu=PI*xmu;
fact = (fabs(pimu) < EPS ? 1.0 : pimu/sin(pimu));
d = -log(x2);
e=xmu*d;
fact2 = (fabs(e) < EPS ? 1.0 : sinh(e)/e);
beschb(xmu,&gam1,&gam2,&gampl,&gammi);  
ff=fact*(gam1*cosh(e)+gam2*fact2*d);  
sum=ff;
e=exp(e);
p=0.5*e/gampl; 
q=0.5/(e*gammi); 
c=1.0;
d=x2*x2;
sum1=p;
for (i=1;i<=MAXIT;i++) {
ff=(i*ff+p+q)/(i*i-xmu2);
c *= (d/i);
p /= (i-xmu);
q /= (i+xmu);
del=c*ff;
sum += del;
del1=c*(p-i*ff);
sum1 += del1;
if (fabs(del) < fabs(sum)*EPS) break;
}
if (i > MAXIT) nrerror("bessk series failed to converge");
rkmu=sum;
rk1=sum1*xi2;
} else {  
b=2.0*(1.0+x);
d=1.0/b;
h=delh=d;
q1=0.0;  
q2=1.0;
a1=0.25-xmu2;
q=c=a1;  
a = -a1;
s=1.0+q*delh;
for (i=2;i<=MAXIT;i++) {
a -= 2*(i-1);
c = -a*c/i;
qnew=(q1-b*q2)/a;
q1=q2;
q2=qnew;
q += c*qnew;
b += 2.0;
d=1.0/(b+a*d);
delh=(b*d-1.0)*delh;
h += delh;
dels=q*delh;
s += dels;
if (fabs(dels/s) < EPS) break;
 
}
if (i > MAXIT) nrerror("bessik: failure to converge in cf2");
h=a1*h;
rkmu=sqrt(PI/(2.0*x))*exp(-x)/s;  
rk1=rkmu*(xmu+x+0.5-h)*xi;
}
rkmup=xmu*xi*rkmu-rk1;
rimu=xi/(f*rkmu-rkmup);  
*ri=(rimu*ril1)/ril;  
*rip=(rimu*rip1)/ril;
for (i=1;i<=nl;i++) {  
rktemp=(xmu+i)*xi2*rk1+rkmu;
rkmu=rk1;
rk1=rktemp;
}
*rk=rkmu;
*rkp=xnu*xi*rkmu-rk1;


}/* end */ 


double chebev(double a,double b,double c[],int m,double x)
{
	double d=0.0,dd=0.0,sv,y,y2;
	int j;
 
	if ((x-a)*(x-b) > 0.0) nrerror("x not in range in routine CHEBEV");
	y2=2.0*(y=(2.0*x-a-b)/(b-a));
	for (j=m-1;j>=1;j--) {
		sv=d;
		d=y2*d-dd+c[j];
		dd=sv;
	}
	return y*d-dd+0.5*c[0];
}/* end */ 



double bessi0(double x)
{
	double ax,ans;
	double y;

	if ((ax=fabs(x)) < 3.75) {
		y=x/3.75;
		y*=y;
		ans=1.0+y*(3.5156229+y*(3.0899424+y*(1.2067492
			+y*(0.2659732+y*(0.360768e-1+y*0.45813e-2)))));
	} else {
		y=3.75/ax;
		ans=(exp(ax)/sqrt(ax))*(0.39894228+y*(0.1328592e-1
			+y*(0.225319e-2+y*(-0.157565e-2+y*(0.916281e-2
			+y*(-0.2057706e-1+y*(0.2635537e-1+y*(-0.1647633e-1
			+y*0.392377e-2))))))));
	}
	return ans;
}/* end */ 



double logbessi0(double x)
{
	double ax,ans;
	double y;

	if ((ax=fabs(x)) < 3.75) {
		y=x/3.75;
		y*=y;
		ans=log(1.0+y*(3.5156229+y*(3.0899424+y*(1.2067492
			+y*(0.2659732+y*(0.360768e-1+y*0.45813e-2))))));
	} else {
		y=3.75/ax;
		ans=ax-0.5*log(ax)+log((0.39894228+y*(0.1328592e-1
			+y*(0.225319e-2+y*(-0.157565e-2+y*(0.916281e-2
			+y*(-0.2057706e-1+y*(0.2635537e-1+y*(-0.1647633e-1
			+y*0.392377e-2)))))))));
	}
	return ans;
}/* end */ 


double bessi1(double x)
{
	double ax,ans;
	double y;

	if ((ax=fabs(x)) < 3.75) {
		y=x/3.75;
		y*=y;
		ans=ax*(0.5+y*(0.87890594+y*(0.51498869+y*(0.15084934
			+y*(0.2658733e-1+y*(0.301532e-2+y*0.32411e-3))))));
	} else {
		y=3.75/ax;
		ans=0.2282967e-1+y*(-0.2895312e-1+y*(0.1787654e-1
			-y*0.420059e-2));
		ans=0.39894228+y*(-0.3988024e-1+y*(-0.362018e-2
			+y*(0.163801e-2+y*(-0.1031555e-1+y*ans))));
		ans *= (exp(ax)/sqrt(ax));
	}
	return x < 0.0 ? -ans : ans;
}/* end */ 



double logbessi1(double x)
{
	double ax,ans;
	double y;

	if ((ax=fabs(x)) < 3.75) {
		y=x/3.75;
		y*=y;
		ans=log(ax*(0.5+y*(0.87890594+y*(0.51498869+y*(0.15084934
			+y*(0.2658733e-1+y*(0.301532e-2+y*0.32411e-3)))))));
	} else {
		y=3.75/ax;
		ans=0.2282967e-1+y*(-0.2895312e-1+y*(0.1787654e-1
			-y*0.420059e-2));
		ans=0.39894228+y*(-0.3988024e-1+y*(-0.362018e-2
			+y*(0.163801e-2+y*(-0.1031555e-1+y*ans))));
		ans=log(ans)+ax-0.5*log(ax);
	}
	return  ans;
}/* end */ 


 
 

void CalPvalue(int NOtest, double *FmaxEmp, float *Ftestvalue, float *Fpvalue) 
{ 
	int dii, djj, dkk;
    int NSint=Nresample-100; 

     for(dii=1; dii<=NOtest; dii++){
         if(Ftestvalue[dii]<FmaxEmp[NSint+1]){ 
			 for(dkk=1; dkk<=NSint+1; dkk=dkk+50){ 
				if(Ftestvalue[dii]<=FmaxEmp[dkk]&&dkk>1){
					for(djj=dkk; djj>=dkk-50; djj--){
						if(Ftestvalue[dii]>FmaxEmp[djj]){
				          Fpvalue[dii]=djj*1.0; 
                          djj=dkk-51;  
						}
					}
                   dkk=Nresample;   
				} 
			 }/* dkk */ 
		 }else{
            for(dkk=Nresample; dkk>=NSint; dkk--) 
 				if(Ftestvalue[dii]>FmaxEmp[dkk]){
			       Fpvalue[dii]=dkk*1.0;
				   dkk=NSint-1; 
				}
		 }		 
//		printf("%14f ", Fpvalue[dii]); 
		if(Fpvalue[dii]<Nresample) 
  		  Fpvalue[dii]=-log10(1.0-(Fpvalue[dii]/(1.0*Nresample))); 
		else 
		  Fpvalue[dii]=3.0; 
//        printf("%14f %14f \n", Ftestvalue[dii], Fpvalue[dii]); 
	 }/* dii */
	 
}/*  end */ 


  

double variance(double dd) 
{
   return exp(-0.53+0.0064*dd-1.9*dd*dd/100000.0+2.1*dd*dd*dd/100000000.0);  
}

double autocorr(double lag) 
{
   return 0.929-0.0013*fabs(lag);  
}

void firstDev(double dd1, double dd2,  double *first) 
{
  
  double sigmaauto, sigma; 

  sigmaauto=sqrt(variance(dd1)*variance(dd2))*autocorr(dd1-dd2);
  sigma=sqrt(variance(dd1)*variance(dd2)); 
  if(dd1!=dd2){
    first[1]=sigmaauto;
    first[2]=0.5*(dd1+dd2)*sigmaauto; 
    first[3]=0.5*(dd1*dd1+dd2*dd2)*sigmaauto;
    first[4]=0.5*(dd1*dd1*dd1+dd2*dd2*dd2)*sigmaauto; 
    first[5]=sigma;
    first[6]=sigma*fabs(dd1-dd2); 
  }else{
    first[1]=sigma;
    first[2]=0.5*(dd1+dd2)*sigma; 
    first[3]=0.5*(dd1*dd1+dd2*dd2)*sigma;
    first[4]=0.5*(dd1*dd1*dd1+dd2*dd2*dd2)*sigma; 
    first[5]=0.0; 
    first[6]=0.0; 
  }
  

}/* end */ 


void firstDevCS(int diag,   double *first) 
{
  
  double sigmaauto, sigma; 

  if(diag==1){
    first[1]=1;
    first[2]=1; 
  }else{
    first[1]=0;
    first[2]=1; 
  }
  

}/* end */ 

void SigmaMatrix(int NoTime, double *dd, double **SigmaI)
{

   int dii, djj; 

   for(dii=1; dii<=NoTime; dii++)
      for(djj=1; djj<=NoTime; djj++){ 
	     if(dii!=djj) 
           SigmaI[dii][djj]=sqrt(variance(dd[dii])*variance(dd[djj]))*autocorr(dd[dii]-dd[djj]); 
	     else 
           SigmaI[dii][djj]=variance(dd[dii]); 
   } 

}/* sigmamatrix */ 



void SigmaMatrixCS(int NoTime, double *sigma2, double **SigmaI)
{

   int dii, djj; 

   for(dii=1; dii<=NoTime; dii++)
      for(djj=1; djj<=NoTime; djj++){ 
	     if(dii!=djj) 
           SigmaI[dii][djj]=sigma2[2]; 
	     else 
           SigmaI[dii][djj]=sigma2[1]+sigma2[2]; 
   } 

}/* sigmamatrix */ 


void Kronecker(int NR1, int NR2, int NC1, int NC2,  double **Sigma1, double **Sigma2, double **KSigma) 
{

  int dii, djj, dkk, dll; 
  
  for(dii=1; dii<=NR1*NR2; dii++)
	  for(djj=1; djj<=NC1*NC2; djj++) 
         KSigma[dii][djj]=0.0; 

  for(dii=1; dii<=NR1; dii++)
	for(djj=1; djj<=NC1; djj++){
       for(dkk=1; dkk<=NR2; dkk++)
		  for(dll=1; dll<=NC2; dll++)
            KSigma[(dii-1)*NR2+dkk][(djj-1)*NC2+dll]=Sigma1[dii][djj]*Sigma2[dkk][dll]; 
	 }/* for */ 

}/* end */ 



void jacobi(double **a, int n, double d[], double **v, int *nrot)
{
	int j,iq,ip,i;
	double tresh,theta,tau,t,sm,s,h,g,c,*b,*z;
 
	b=dvector(1,n);
	z=dvector(1,n);
	for (ip=1;ip<=n;ip++) {
		for (iq=1;iq<=n;iq++) v[ip][iq]=0.0;
		v[ip][ip]=1.0;
	}
	for (ip=1;ip<=n;ip++) {
		b[ip]=d[ip]=a[ip][ip];
		z[ip]=0.0;
	}
	*nrot=0;
	for (i=1;i<=50;i++) {
		sm=0.0;
		for (ip=1;ip<=n-1;ip++) {
			for (iq=ip+1;iq<=n;iq++)
				sm += fabs(a[ip][iq]);
		}
		if (sm == 0.0) {
			free_dvector(z,1,n);
			free_dvector(b,1,n);
			return;
		}
		if (i < 4)
			tresh=0.2*sm/(n*n);
		else
			tresh=0.0;
		for (ip=1;ip<=n-1;ip++) {
			for (iq=ip+1;iq<=n;iq++) {
				g=100.0*fabs(a[ip][iq]);
				if (i > 4 && fabs(d[ip])+g == fabs(d[ip])
					&& fabs(d[iq])+g == fabs(d[iq]))
					a[ip][iq]=0.0;
				else if (fabs(a[ip][iq]) > tresh) {
					h=d[iq]-d[ip];
					if (fabs(h)+g == fabs(h))
						t=(a[ip][iq])/h;
					else {
						theta=0.5*h/(a[ip][iq]);
						t=1.0/(fabs(theta)+sqrt(1.0+theta*theta));
						if (theta < 0.0) t = -t;
					}
					c=1.0/sqrt(1+t*t);
					s=t*c;
					tau=s/(1.0+c);
					h=t*a[ip][iq];
					z[ip] -= h;
					z[iq] += h;
					d[ip] -= h;
					d[iq] += h;
					a[ip][iq]=0.0;
					for (j=1;j<=ip-1;j++) {
						ROTATE(a,j,ip,j,iq)
					}
					for (j=ip+1;j<=iq-1;j++) {
						ROTATE(a,ip,j,j,iq)
					}
					for (j=iq+1;j<=n;j++) {
						ROTATE(a,ip,j,iq,j)
					}
					for (j=1;j<=n;j++) {
						ROTATE(v,j,ip,j,iq)
					}
					++(*nrot);
				}
			}
		}
		for (ip=1;ip<=n;ip++) {
			b[ip] += z[ip];
			d[ip]=b[ip];
			z[ip]=0.0;
		}
	}
	printf("Too many iterations in routine JACOBI");
}
 


void EMlinearMixed(double** MX, double* VY, int* NoEachSub, int TotalSub, int TotalPoint, int NXP, double* beta, double* sigma2, int MaxNoTime)
{
 
  
    double   **phi, **sigi, **IVI11, **CA;
	int i, j, k, l,   mi, t,dii, NN, KK, MK, item, ttmp;
	double *XY, tpp, tp, ct, *yi, **xi, *LLS, *bi, **PH, *oo, **om, **zz;
    double **XX, **OM, **xxi, **randm, **phi0;
    int hv=0;

     KK=1; 
     NN=TotalSub; 
     MK=KK*MaxNoTime; /* number of random effects */ 

	     
 	XX =  dmatrix(1, NXP, 1, NXP);
	XY =  dvector(1, NXP); 
	
 
    for(i=1; i<=NXP; i++){
		for(j=1; j<=NXP; j++){
			XX[i][j]=0.0;
			for(k=1; k<=TotalPoint; k++)
				XX[i][j]+=MX[k][i]*MX[k][j];
		}
		XY[i]=0.0;
		for(k=1; k<=TotalPoint; k++)
			XY[i]+=MX[k][i]*VY[k];                    
	}
    
    iv(XX,NXP);
    
	for(i=1;i<=NXP;i++){
		 beta[i]=0.0;
		for(j=1;j<=NXP;j++)
			 beta[i]+=XX[i][j]*XY[j];
//		cout << beta[i]<<"\n";
	}
	
    free_dmatrix(XX, 1, NXP, 1, NXP);
	free_dvector(XY, 1, NXP);
	
	 
	sigi=dmatrix(1, KK, 1, KK);
	for(k=1;k<=KK;k++){
		tpp=0.0;
		for(i=1;i<=TotalPoint;i++){
			dii=k+(i-1)*KK;
			tp=VY[dii];
			for(j=1;j<=NXP;j++)
				tp+=-MX[dii][j]*beta[j];
			tpp+=tp*tp/(TotalPoint-1.0);  }
		for(i=1;i<=KK;i++)
			sigi[k][i]=0.0;
		sigi[k][k]=tpp*0.8;
	}

 	phi=dmatrix(1, KK, 1, KK);
    for(i=1;i<=KK;i++){
		for(j=1;j<=KK;j++)
			phi[i][j]=0.0;
		phi[i][i]=1.0;
	} 

 
	/* end to set initial parameter phi and beta  */

    IVI11=dmatrix(1, NXP, 1, NXP);
	ct=0.5; item=0;    
	while(ct>0.000001){                     /* begin to iteration  */
/*	for(item=1;item<=50;item++){  */
		item+=1;
		if(item>700){
			break;
		} 
		XX=dmatrix(1, KK, 1, KK);
		PH=dmatrix(1, KK, 1, KK);
		LLS=dvector(1, KK);
		
		for(j=1;j<=KK;j++){
			for(l=1;l<=KK;l++){
				XX[j][l]=phi[j][l];
				PH[j][l]=0.0;
			}
            LLS[j]=0.0;
		}
		
        iv(XX, KK);   /* phi^{-1} */
	    int hh=0;
		for(i=1;i<=NN;i++){   /* begin i  */			
			XY=dvector(1, KK);
			mi=NoEachSub[i]; 
			for(k=1;k<=KK;k++){
				tpp=0.0;
                for(j=1;j<=mi;j++){
					dii=hh+k+(j-1)*KK;
					tp=VY[dii];
					for(l=1;l<=NXP;l++)
						tp+=-MX[dii][l]*beta[l];
					tpp+=tp;
				}
				XY[k]=tpp/sigi[k][k];
			}   
			OM=dmatrix(1, KK, 1, KK);
			for(j=1;j<=KK;j++){
				for(k=1;k<=KK;k++)
					OM[j][k]=XX[j][k];
				OM[j][j]=XX[j][j]+(mi+0.0)/sigi[j][j];
			}            
			iv(OM,KK);  
			bi=dvector(1, KK);
			for(j=1;j<=KK;j++){
				tp=0.0;
				for(k=1;k<=KK;k++)
					tp+=OM[j][k]*XY[k];
				bi[j]=tp;
			}
			for(j=1;j<=KK;j++)
				for(k=1;k<=KK;k++)
					OM[j][k]=bi[j]*bi[k]+OM[j][k];    /* hat{phi}_i */
			for(k=1;k<=KK;k++){
				tpp=0.0;
				for(j=1;j<=mi;j++){
					ttmp=hh+k+(j-1)*KK;
					tp=VY[ttmp]-bi[k];					
					for(l=1;l<=NXP;l++)
						tp+=-MX[ttmp][l]*beta[l];
					tpp+=tp*tp;}
                LLS[k]+=tpp;
			}

			for(j=1;j<=KK;j++)
				for(k=1;k<=KK;k++) 
					PH[j][k]+=OM[j][k];

			free_dmatrix(OM, 1, KK, 1, KK);
			free_dvector(XY, 1, KK);
			free_dvector(bi, 1, KK);
            
			hh+=mi*KK;
		}   /* end i */

        ct=0.0;
		for(j=1;j<=KK;j++)
            for(k=1;k<=KK;k++)
				ct+=(PH[j][k]/(NN+0.0)-phi[j][k])*(PH[j][k]/(NN+0.0)-phi[j][k]);

		for(j=1;j<=KK;j++)
			for(k=1;k<=KK;k++)
				phi[j][k]=PH[j][k]/(NN+0.0);

		free_dmatrix(PH, 1, KK, 1, KK);
        free_dmatrix(XX, 1, KK, 1, KK);

		XX=dmatrix(1, KK, 1, KK);
		PH=dmatrix(1, KK, 1, KK);
		for(j=1;j<=KK;j++)
			for(k=1;k<=KK;k++)
				XX[j][k]=phi[j][k];
		       
		iv(XX,KK);   /* XX=phi^{-1}  new  */

		for(k=1;k<=KK;k++){
			tp=0.0;
			for(i=1;i<=NN;i++){
			    mi=NoEachSub[i];	
				for(j=1;j<=KK;j++)
					for(l=1;l<=KK;l++)
						PH[j][l]=XX[j][l];
				PH[k][k]=XX[k][k]+(mi+0.0)/sigi[k][k];	
				iv(PH,KK);
				tp+=(mi+0.0)*PH[k][k];
			}
            sigi[k][k]=(LLS[k]+tp)/(TotalPoint+0.0);
		}

		free_dmatrix(XX, 1, KK, 1, KK);
		free_dmatrix(PH, 1, KK, 1, KK);
		free_dvector(LLS, 1, KK);

		xi=dmatrix(1, MK, 1, NXP);
		yi=dvector(1, MK);		
		oo=dvector(1, MK);
		om=dmatrix(1, MK, 1, KK);
        zz=dmatrix(1, NXP, 1, MK);
		XY=dvector(1, NXP);
		OM=dmatrix(1, NXP, 1, NXP);
        
		for(j=1;j<=NXP;j++)
			XY[j]=0.0;
		for(j=1;j<=NXP;j++)
			for(k=1;k<=NXP;k++)
				OM[j][k]=0.0;

        hh=0;
		for(i=1;i<=NN;i++){   /* begin i */
            mi=NoEachSub[i]; 
			int hm=0;
			for(j=1;j<=mi;j++){
				for(k=1;k<=KK;k++){
					hm+=1; hh+=1;
					yi[hm]=VY[hh];
					for(l=1;l<=NXP;l++)
						xi[hm][l]=MX[hh][l];
					for(l=1;l<=KK;l++)
						om[hm][l]=phi[k][l];
                    oo[hm]=sigi[k][k];
				}
			}

		    XX=dmatrix(1, hm, 1, hm);   /* MK is the maximum row number of Xi */
			for(j=1;j<=mi;j++)
				for(k=1;k<=KK;k++)
                    for(l=1;l<=hm;l++)
						XX[l][k+(j-1)*KK]=om[l][k];   /* Z_i*phi*Z_i' */
			
			for(j=1;j<=hm;j++)
				XX[j][j]=XX[j][j]+oo[j];   /* Sigma_i */ 
			   			
			iv(XX,hm);   /* Sigma_i^{-1} */

			for(j=1;j<=NXP;j++){
				for(l=1;l<=hm;l++){
					zz[j][l]=0.0;
					for(k=1;k<=hm;k++)
						zz[j][l]+=xi[k][j]*XX[k][l];					
				}
			}

			free_dmatrix(XX ,1 ,hm, 1, hm);

			for(j=1;j<=NXP;j++){
				for(l=1;l<=NXP;l++)
					for(k=1;k<=hm;k++)
						OM[j][l]+=zz[j][k]*xi[k][l];
				for(k=1;k<=hm;k++)
					XY[j]+=zz[j][k]*yi[k];
			}
		}/* end i */
        
		free_dmatrix(xi, 1, MK, 1, NXP);		
		free_dmatrix(om, 1, MK, 1, KK);
		free_dmatrix(zz, 1, NXP, 1, MK);
		free_dvector(yi, 1, MK);
		free_dvector(oo, 1, MK);
        
		iv(OM,NXP);   /* (sum Xi'*Sigmai^{-1}*Xi)^{-1} */
        double *KB;
		KB=dvector(1,NXP);
		for(i=1;i<=NXP;i++){
			KB[i]=0.0;
			for(j=1;j<=NXP;j++)
				KB[i]+=OM[i][j]*XY[j];
		}

        for(i=1; i<=NXP; i++)
			for(j=1; j<=NXP; j++) 
				IVI11[i][j]=OM[i][j];    /* IVI11=(sum Xi'*Sigmai^{-1}*Xi)^{-1} */

		for(i=1;i<=NXP;i++)
			ct+=(KB[i]-beta[i])*(KB[i]-beta[i]);

		for(i=1;i<=NXP;i++) 
			beta[i]=KB[i];
 
		ct=sqrt(ct);
		free_dmatrix(OM, 1, NXP, 1, NXP);  
		free_dvector(XY, 1, NXP);
		free_dvector(KB, 1, NXP);
        
        
	 }/* end iteration */

	 sigma2[2]=phi[1][1]; 
     sigma2[1]=sigi[1][1]; 
	
	free_dmatrix(sigi, 1, KK, 1, KK);
	free_dmatrix(phi, 1, KK, 1, KK);
	free_dmatrix(IVI11, 1, NXP, 1, NXP); 

 	
// 	cout<<sigma2[1]<<" "<<sigma2[2]<<endl;
// 	cout<<"(Iterations) "<<item<<endl; 
	
	 

}/* EMlinearMixed */ 


void EMlinearMixedCase(int hongtu, double** MX, double* VY, int* NoEachSub, int TotalSub, int TotalPoint, int NXP, double* beta, double* sigma2,  int MaxNoTime)
{
	
	
    double   **phi, **sigi, **IVI11, **CA;
	int i, j, k, l, dii,  mi, t, NN, KK, MK, item, NOdelte, ttmp;
	double *XY, tpp, tp, ct, *yi, **xi, *LLS, *bi, **PH, *oo, **om, **zz;
    double **XX, **OM, **xxi, **randm, **phi0; 
	int *deleteOBS;
    int hv=0;
	
	KK=1; 
	if(hongtu>0)
	  NN=TotalSub-1;
	else
	  NN=TotalSub;
	MK=KK*MaxNoTime; /* number of random effects */ 
	
	deleteOBS=ivector(1, TotalPoint); 
 	XX =  dmatrix(1, NXP, 1, NXP);
	XY =  dvector(1, NXP); 
	
//	cout << hongtu<<" ";
	
	mi=1;
	NOdelte=0; 
	for(i=1; i<=TotalSub; i++){
	    for(j=1; j<=NoEachSub[i]; j++){
			if(i==hongtu)
				deleteOBS[mi]=1;
			else
				deleteOBS[mi]=0;
			NOdelte+=deleteOBS[mi]; 
		    mi++; 	
		}
	}
	
	
    for(i=1; i<=NXP; i++){
		for(j=1; j<=NXP; j++){
			XX[i][j]=0.0;
			for(k=1; k<=TotalPoint; k++)
			   if(deleteOBS[k]<=0)	
				XX[i][j]+=MX[k][i]*MX[k][j];
		}
		XY[i]=0.0;
		for(k=1; k<=TotalPoint; k++)
			if(deleteOBS[k]<=0)		
 			   XY[i]+=MX[k][i]*VY[k];   
//		printf("%14lf\n ", XY[i]);	
	}

    
    iv(XX,NXP);
	
//	matrixPrint(NXP, NXP, XX); 
    
	for(i=1;i<=NXP;i++){
		beta[i]=0.0;
//		printf("%14lf ", beta[i]); 
		for(j=1;j<=NXP;j++)
			beta[i]+=XX[i][j]*XY[j];
	}
	
    free_dmatrix(XX, 1, NXP, 1, NXP);
	free_dvector(XY, 1, NXP);
	
	
	sigi=dmatrix(1, KK, 1, KK);
	for(k=1;k<=KK;k++){
		tpp=0.0;
		for(i=1;i<=TotalPoint;i++)
		    if(deleteOBS[i]<=0){
			dii=k+(i-1)*KK;
			tp=VY[dii];
			for(j=1;j<=NXP;j++)
				tp+=-MX[dii][j]*beta[j];
			tpp+=tp*tp/(TotalPoint-NOdelte-1.0); 
			}
		for(i=1;i<=KK;i++)
			sigi[k][i]=0.0;
		sigi[k][k]=tpp*0.8;
	}
	
 	phi=dmatrix(1, KK, 1, KK);
    for(i=1;i<=KK;i++){
		for(j=1;j<=KK;j++)
			phi[i][j]=0.0;
		phi[i][i]=1.0;
	} 
	
// 	for(i=1; i<=NXP; i++)
//  		printf("%14lf ", beta[i]); 
	
	/* end to set initial parameter phi and beta  */
	
    IVI11=dmatrix(1, NXP, 1, NXP);
	ct=0.5; item=0;    
	while(ct>0.00001){                     /* begin to iteration  */
		/*	for(item=1;item<=50;item++){  */
		item+=1;
		if(item>700){
			break;
		} 
		XX=dmatrix(1, KK, 1, KK);
		PH=dmatrix(1, KK, 1, KK);
		LLS=dvector(1, KK);
		
		for(j=1;j<=KK;j++){
			for(l=1;l<=KK;l++){
				XX[j][l]=phi[j][l];
				PH[j][l]=0.0;
			}
            LLS[j]=0.0;
		}
		
        iv(XX, KK);   /* phi^{-1} */
	    int hh=0;
		OM=dmatrix(1, KK, 1, KK);
		XY=dvector(1, KK);
		 bi=dvector(1, KK);

		for(i=1;i<=TotalSub;i++){   /* begin i  */			
					mi=NoEachSub[i]; 
			if(i!=hongtu){ 	
			  for(k=1;k<=KK;k++){
				 tpp=0.0; tp=0.0; 
                 for(j=1;j<=mi;j++){
					 dii=hh+k+(j-1)*KK;
					 tp=VY[dii];
					 for(l=1;l<=NXP;l++)
						 tp+=-MX[dii][l]*beta[l];
					 tpp+=tp;
				 }
				  XY[k]=tpp/sigi[k][k];
			  }   
			  for(j=1;j<=KK;j++)
			 	  for(k=1;k<=KK;k++)
			  	     OM[j][j]=XX[j][j]+(mi+0.0)/sigi[j][j];
			  iv(OM,KK);  
			  for(j=1;j<=KK;j++){
			 	 tp=0.0;
				 for(k=1;k<=KK;k++)
					 tp+=OM[j][k]*XY[k];
				 bi[j]=tp;
			  }
			  for(j=1;j<=KK;j++)
				  for(k=1;k<=KK;k++)
					 OM[j][k]=bi[j]*bi[k]+OM[j][k];    /* hat{phi}_i */
			  for(k=1; k<=KK;k++){
				 tpp=0.0;
				 for(j=1;j<=mi;j++){
					 ttmp=hh+k+(j-1)*KK;
	  			     tp=VY[ttmp]-bi[k];					
					 for(l=1;l<=NXP;l++)
					 	tp+=-MX[ttmp][l]*beta[l];
					 tpp+=tp*tp;
					 }
                  LLS[k]+=tpp;
			  }
			  for(j=1;j<=KK;j++)
				  for(k=1;k<=KK;k++) 
					  PH[j][k]+=OM[j][k];
	     	}/* end */ 	
			
		    hh+=mi*KK;
			
	}/* end i */

		free_dmatrix(OM, 1, KK, 1, KK);
		free_dvector(XY, 1, KK);
		free_dvector(bi, 1, KK);
		
        ct=0.0;
		for(j=1;j<=KK;j++)
            for(k=1;k<=KK;k++)
				ct+=(PH[j][k]/(NN+0.0)-phi[j][k])*(PH[j][k]/(NN+0.0)-phi[j][k]);
		
		for(j=1;j<=KK;j++)
			for(k=1;k<=KK;k++)
				phi[j][k]=PH[j][k]/(NN+0.0);
		
		free_dmatrix(PH, 1, KK, 1, KK);
        free_dmatrix(XX, 1, KK, 1, KK);
		
		XX=dmatrix(1, KK, 1, KK);
		PH=dmatrix(1, KK, 1, KK);
		for(j=1;j<=KK;j++)
			for(k=1;k<=KK;k++)
				XX[j][k]=phi[j][k];
		
		iv(XX,KK);   /* XX=phi^{-1}  new  */
		
		for(k=1;k<=KK;k++){
			tp=0.0;
			for(i=1;i<=TotalSub;i++)
			   if(i!=hongtu){
			    mi=NoEachSub[i];	
				for(j=1;j<=KK;j++)
					for(l=1;l<=KK;l++)
						PH[j][l]=XX[j][l];				
				PH[k][k]=XX[k][k]+(mi+0.0)/sigi[k][k];	
				iv(PH,KK);
				tp+=(mi+0.0)*PH[k][k];
			}
            sigi[k][k]=(LLS[k]+tp)/(TotalPoint-NOdelte+0.0);
		}
		
		free_dmatrix(XX, 1, KK, 1, KK);
		free_dmatrix(PH, 1, KK, 1, KK);
		free_dvector(LLS, 1, KK);
		
		xi=dmatrix(1, MK, 1, NXP);
		yi=dvector(1, MK);		
		oo=dvector(1, MK);
		om=dmatrix(1, MK, 1, KK);
        zz=dmatrix(1, NXP, 1, MK);
		XY=dvector(1, NXP);
		OM=dmatrix(1, NXP, 1, NXP);
        
		for(j=1;j<=NXP;j++)
			XY[j]=0.0;
		for(j=1;j<=NXP;j++)
			for(k=1;k<=NXP;k++)
				OM[j][k]=0.0;
		
        hh=0;
		for(i=1;i<=TotalSub;i++){   /* begin i */
              mi=NoEachSub[i]; 
			  int hm=0;
			  for(j=1;j<=mi;j++){
				 for(k=1;k<=KK;k++){
					hm+=1; 
					hh+=1;
					yi[hm]=VY[hh];
					for(l=1;l<=NXP;l++)
						xi[hm][l]=MX[hh][l];
					for(l=1;l<=KK;l++)
						om[hm][l]=phi[k][l];
                    oo[hm]=sigi[k][k];
				}
			}
			
			if(i!=hongtu){
		      XX=dmatrix(1, hm, 1, hm);   /* MK is the maximum row number of Xi */
		  	  for(j=1;j<=mi;j++)
				for(k=1;k<=KK;k++)
                    for(l=1;l<=hm;l++)
						XX[l][k+(j-1)*KK]=om[l][k];   /* Z_i*phi*Z_i' */
			
 			  for(j=1; j<=hm; j++)
				 XX[j][j]=XX[j][j]+oo[j];   /* Sigma_i */ 
			
 			  iv(XX,hm);   /* Sigma_i^{-1} */
			
			  for(j=1;j<=NXP;j++){
				for(l=1;l<=hm;l++){
					zz[j][l]=0.0;
					for(k=1;k<=hm;k++)
						zz[j][l]+=xi[k][j]*XX[k][l];					
				 }
			 }
			
			 free_dmatrix(XX ,1 ,hm, 1, hm);
			
			 for(j=1;j<=NXP;j++){
			 	for(l=1;l<=NXP;l++)
					for(k=1;k<=hm;k++)
						OM[j][l]+=zz[j][k]*xi[k][l];
				for(k=1;k<=hm;k++)
					XY[j]+=zz[j][k]*yi[k];
			}
			}/* if */ 
		}/* end i */
        
		free_dmatrix(xi, 1, MK, 1, NXP);		
		free_dmatrix(om, 1, MK, 1, KK);
		free_dmatrix(zz, 1, NXP, 1, MK);
		free_dvector(yi, 1, MK);
		free_dvector(oo, 1, MK);
        
		iv(OM,NXP);   /* (sum Xi'*Sigmai^{-1}*Xi)^{-1} */
        double *KB;
		KB=dvector(1,NXP);
		for(i=1;i<=NXP;i++){
			KB[i]=0.0;
			for(j=1;j<=NXP;j++)
				KB[i]+=OM[i][j]*XY[j];
		}
		
        for(i=1; i<=NXP; i++)
			for(j=1; j<=NXP; j++) 
				IVI11[i][j]=OM[i][j];    /* IVI11=(sum Xi'*Sigmai^{-1}*Xi)^{-1} */
		
		for(i=1;i<=NXP;i++)
			ct+=(KB[i]-beta[i])*(KB[i]-beta[i]);
		
		for(i=1;i<=NXP;i++) 
			beta[i]=KB[i];
		
		ct=sqrt(ct);
		free_dmatrix(OM, 1, NXP, 1, NXP);  
		free_dvector(XY, 1, NXP);
		free_dvector(KB, 1, NXP);
        
        
	}/* end iteration */
	
	sigma2[2]=phi[1][1]; 
	sigma2[1]=sigi[1][1];
	
	free_dmatrix(sigi, 1, KK, 1, KK);
	free_dmatrix(phi, 1, KK, 1, KK);
	free_dmatrix(IVI11, 1, NXP, 1, NXP);	
	free_ivector(deleteOBS, 1, TotalPoint); 

	
//	cout<<sigma2[1]<<" "<<sigma2[2]<<endl;
//	cout<<"(Iterations) "<<item<<endl; 
	
	
}/* EMlinearMixed */ 



void FirstCookDistance(int TotalCov, double* CDF,  double* residual, int*  NoEachSub, int TotalSub, int NoTimeMax, float***  IQmatrix, float*** IRmatrix, float*** Hmatrix)
{
 
	int dii, djj, dkk, dmm, dnn, start, end; 	
	double *tempERQ; 
	
	
	tempERQ=dvector(1, NoTimeMax); 

	for(dii=1; dii<=TotalSub; dii++){
		if(dii==1){
			start=0; 
			end=NoEachSub[dii]; 
		} 
		else{ 
			start+=NoEachSub[dii-1]; 
			end+=NoEachSub[dii]; 
		} 
		for(djj=1; djj<=NoEachSub[dii]; djj++){
	       tempERQ[djj]=0.0; 	
			for(dkk=start+1; dkk<=end; dkk++)
				for(dmm=1; dmm<=NoEachSub[dii]; dmm++)
					tempERQ[djj]+=residual[dkk]*IRmatrix[dii][dkk-start][dmm]*IQmatrix[dii][dmm][djj];
		}/* djj */ 
		CDF[dii]=0.0;
		for(djj=1; djj<=NoEachSub[dii]; djj++) 
            for(dkk=1; dkk<=NoEachSub[dii]; dkk++) 
			    CDF[dii]+=tempERQ[djj]*Hmatrix[dii][djj][dkk]*tempERQ[dkk]; 
	} 	 
	
	free_dvector(tempERQ, 1, NoTimeMax); 
	
	
}/* end */  

void SimulateLMMold(double perturb, int TotalSub, int* NoEachSub, double* mean, double* truesigma2, double* VYY)
{
	int dii, djj, start, end;
 	double tempt; 
	
for(dii=1; dii<=TotalSub; dii++){
	if(dii==1){
		start=0; 
		end=NoEachSub[dii]; 
	} 
	else{ 
		start+=NoEachSub[dii-1]; 
		end+=NoEachSub[dii]; 
	} 
	tempt=gasdev()*sqrt(truesigma2[2]); 

 
//	if (dii>TotalSub-1) {
//		tempt=perturb; 	
//	}

	if (dii==TotalSub) {
		tempt=3; 	
	    }
	if (dii==TotalSub-1) {
		tempt=4; 	
	   }	
	
	for(djj=start+1; djj<=end; djj++) 
		VYY[djj]=mean[djj]+tempt+gasdev()*sqrt(truesigma2[1]); 
 	
	
	
/*
	  

 if (dii==TotalSub) {
		tempt=gasdev()*0.2; 
		for(djj=start+1; djj<=end-2; djj++) 
			VYY[djj]=mean[djj]+tempt+gasdev()*sqrt(truesigma2[1]);  
		tempt=3.0; 
		for(djj=end-1; djj<=end; djj++) 
			VYY[djj]=mean[djj]+tempt+gasdev()*sqrt(truesigma2[1]);  	
	}
*/ 
 
}/* for */ 


}/* end */ 



void SimulateLMM(int TotalSub, int* NoEachSub, double* mean, double* truesigma2, double* VYY)
{
	int dii, djj, start, end;
 	double tempt; 
	
	for(dii=1; dii<=TotalSub; dii++){
		if(dii==1){
			start=0; 
			end=NoEachSub[dii]; 
		} 
		else{ 
			start+=NoEachSub[dii-1]; 
			end+=NoEachSub[dii]; 
		} 
		tempt=gasdev()*sqrt(truesigma2[2]); 
		
		for(djj=start+1; djj<=end; djj++) 
			VYY[djj]=mean[djj]+tempt+gasdev()*sqrt(truesigma2[1]); 
		
		
		/*	
		 if (dii==TotalSub-1) {
		 tempt=4; 	
		 }
		 if (dii==TotalSub) {
		 tempt=3; 	
		 }  
		 */  
		
		/*
		 if (dii==TotalSub) {
		 tempt=gasdev()*0.2; 
		 for(djj=start+1; djj<=end-2; djj++) 
		 VYY[djj]=mean[djj]+tempt+gasdev()*sqrt(truesigma2[1]);  
		 tempt=3.0; 
		 for(djj=end-1; djj<=end; djj++) 
		 VYY[djj]=mean[djj]+tempt+gasdev()*sqrt(truesigma2[1]);  	
		 }
		 */ 
		
	}/* for */ 
	
	
}/* end */ 



void GenerateCov(int TotalCOV, int TotalSub, int* NoEachSub, double** designData) 	   
{

	int dii, djj, dll, dkk;	
	
	dll=1;    
    for(dii=1; dii<=TotalSub; dii++)
      for(dkk=1; dkk<=NoEachSub[dii]; dkk++){
	    for(djj=1; djj<=TotalCOV+1; djj++){
		    if(djj==1) 
			    designData[dll][djj]=dii;
	  	    if(djj==2) 
				designData[dll][djj]=1.0;
			if(djj==3){
				if(dkk==1)
				  designData[dll][djj]=gasdev();
				else  
					designData[dll][djj]=designData[dll-1][djj];
			} 
			if(djj==4)
				designData[dll][djj]=log(dkk*1.0);
 	
//				designData[dll][djj]=dkk+s_xuni()-0.5;
		  }
	    dll++;
	  }
 //	matrixPrint(dll-1, TotalCOV+1, designData); 
	
}/* end */ 


void matrixPrint(int NrowA, int NcolA, double** AA)
{
	int dii, djj;
	
	for(dii=1; dii<=NrowA; dii++){
		for(djj=1; djj<=NcolA; djj++)
			printf("%lf ", AA[dii][djj]);
		printf("\n");
	}/* dii */  
	
}


void CDstatistics(int Nboots, double* ICDboots, double* statistics)
{
	int dii, djj, dkk, dll; 
    double tempt, *temptCD;  	
	double IECD,  ISTD,  IQCD,  IMQCD; 
	
	temptCD=dvector(1, Nboots); 
	
	IECD=0.0; 
	ISTD=0.0; 
	for (dii=1; dii<=Nboots; dii++) {
        IECD+=ICDboots[dii]; 
		ISTD+=ICDboots[dii]*ICDboots[dii]; 
	}
	IECD=IECD/(Nboots*1.0);
	ISTD=sqrt(ISTD/(Nboots*1.0)-IECD*IECD);
 	
	sort2(Nboots, ICDboots); 
	if(Nboots%2==0){
	  dii=(int)(Nboots/2);
	  IQCD=(ICDboots[dii]+ICDboots[dii+1])*0.5; 
	}else {
		dii=(int)(Nboots/2);
		IQCD=ICDboots[dii]; 	 
	}
 	for (dii=1; dii<=Nboots; dii++) 
	    temptCD[dii]=fabs(ICDboots[dii]-IQCD); 	
    sort2(Nboots, temptCD); 
     
 
	
	if(Nboots%2==0){
		dii=(int)(Nboots/2);
		IMQCD=(temptCD[dii]+temptCD[dii+1])*0.5; 
	}else {
		dii=(int)(Nboots/2);
		IMQCD=temptCD[dii]; 	 
	}
 
	
	statistics[1]=IECD;
	statistics[2]=ISTD;
	statistics[3]=IQCD;
	statistics[4]=IMQCD;


    free_dvector(temptCD, 1, Nboots); 
	
}/* end */ 



void orderINDlocal( double** CDboots, double* CSCD1, float* quantile, int TotalSub)
{ 

	int dii, djj, dll, dkk, control;
	double tempt, *temptSIMUcd;
	
	temptSIMUcd=dvector(1, TotalSub*100); 
	
 dll=1; 
 for (dii=1; dii<=TotalSub; dii++)
   for(djj=1; djj<=100; djj++){
 	 temptSIMUcd[dll]=CDboots[dii][djj];
	 dll++; 
 }
 sort2(TotalSub*100, temptSIMUcd);

 
	
	
 for(dii=1; dii<=TotalSub; dii++){
	   control=0;
	   djj=1;
	   quantile[dii]=0.0; 
	   do{		   
		 if(djj==1){
		   if(CSCD1[dii]<=temptSIMUcd[djj]){ 
			 quantile[dii]=djj/(TotalSub*100.0);
			 control=1;
			 } 
		 }else if((CSCD1[dii]<=temptSIMUcd[djj])&(CSCD1[dii]>temptSIMUcd[djj-1])) {
			 quantile[dii]=djj/(TotalSub*100.0);			  
			 control=1; 
		 }
		  djj++;
		   if(djj>TotalSub*100){
			   quantile[dii]=1.0;			  
			   control=1; 
		   }
	   }while(control==0);	
	}/* dii */

	free_dvector(temptSIMUcd, 1, TotalSub*100); 

	
}/* end */ 



void orderCD(double* CD, float* quantile, int TotalSub)
{ 
	
	int dii, djj, dll, dkk, control;
	double tempt, *temptSIMUcd;
	
	temptSIMUcd=dvector(1, TotalSub); 
	
	for (dii=1; dii<=TotalSub; dii++)
			temptSIMUcd[dii]=CD[dii];
	sort2(TotalSub, temptSIMUcd);
	
	
	for(dii=1; dii<=TotalSub; dii++){
		control=0;
		djj=1;
		quantile[dii]=0.0; 
		do{		   
			if(djj<=1){
			  if(CD[dii]<=temptSIMUcd[djj]){ 
					quantile[dii]=djj/(TotalSub*1.0);
					control=1;
				} 
			}else{ if((CD[dii]<=temptSIMUcd[djj])&(CD[dii]>temptSIMUcd[djj-1])) {
				quantile[dii]=djj/(TotalSub*1.0);			  
				control=1; 
			}
			}
			djj++;
			if(djj>TotalSub){ 
				quantile[dii]=1.0;			  
				control=1; 
			}
		}while(control==0);	
	}/* dii */
	
 
	
	free_dvector(temptSIMUcd, 1, TotalSub); 
	
	
}/* end */ 



void CovarianceAR1(double **MX,  int *NoEachSub, int TotalSub, int TotalPoint,   double *sigma2, double ***FixCov, double ***InvFixCov)
{
	
	int dii, djj, dkk, dll, dmm, dnn, start1, end1; 
	double day1, day2, dayDiff, V1, V2, rho; 
	
	for (dii=1; dii<=TotalSub; dii++) {
//		printf("[%d] ", dii);
		if(dii==1){
			start1=0;
			end1=NoEachSub[dii];
		}else{
			start1+=NoEachSub[dii-1];
			end1+=NoEachSub[dii];
		}
 		DMatrixConst(0.0, FixCov[dii], 1, NoEachSub[dii], 1, NoEachSub[dii]); 
        for (djj=1; djj<=NoEachSub[dii]; djj++) 
		    for (dkk=djj; dkk<=NoEachSub[dii]; dkk++) {
				day1=MX[start1+djj][2]; 
				day2=MX[start1+dkk][2]; 
				dayDiff=fabs(day1-day2); 
				V1=-0.53+0.0064*day1-1.9*day1*day1*0.00001+2.1*day1*day1*day1*0.00000001;
				V2=-0.53+0.0064*day2-1.9*day2*day2*0.00001+2.1*day2*day2*day2*0.00000001;
                rho=0.929-0.0013*dayDiff; 
//				printf("%lf %lf %lf %lf %lf %lf\n", day1, day2, dayDiff, V1, V2, rho);
				if(djj==dkk)
					FixCov[dii][djj][dkk]=exp(V1); 	
				else 
		  		    FixCov[dii][djj][dkk]=exp(V1*0.5+V2*0.5)*rho; 
				FixCov[dii][dkk][djj]= FixCov[dii][djj][dkk];
				InvFixCov[dii][djj][dkk]= FixCov[dii][dkk][djj];
				InvFixCov[dii][dkk][djj]= FixCov[dii][dkk][djj];
			}
 //           matrixPrint(NoEachSub[dii], NoEachSub[dii], FixCov[dii]); 
		iv(InvFixCov[dii], NoEachSub[dii]);
	}/* dii */ 
	
	
}/* end CovarianceAR1 */  

					 
void  DMatrixConst(double Const, double **AAA, int Rlow, int Rup, int Clow, int Cup)
{

 	 int dii, djj;

    for(dii=Rlow; dii<=Rup; dii++)
		for(djj=Clow; djj<=Cup; djj++) 
			AAA[dii][djj]=Const;  					 
								
}/* end DMatrixConst */ 
					 



void EMlinearMixedAR1(double **MX, double *VY, int *NoEachSub, int TotalSub, int TotalPoint, int NXP, double *beta, double *sigma2, double ***InvFixCov, double *residual)
{
	
	 
	int i, j, k, l, dii, djj, dkk, start1, end1;
	double *XY, **XX;
 
	
	
	
 	XX =  dmatrix(1, NXP, 1, NXP);
	XY =  dvector(1, NXP); 
	
	
    for(i=1; i<=NXP; i++){
		XY[i]=0.0;
		for(j=1; j<=NXP; j++) 
			XX[i][j]=0.0;
	} 		
			
			
	for(dii=1; dii<=TotalSub; dii++){
		if(dii==1){
					start1=0;
					end1=NoEachSub[dii];
		}else{
					start1+=NoEachSub[dii-1];
					end1+=NoEachSub[dii];
		} 
		for (djj=1; djj<=NoEachSub[dii]; djj++) 
			for (dkk=1; dkk<=NoEachSub[dii]; dkk++){ 
				for(i=1; i<=NXP; i++){ 
					for(j=1; j<=NXP; j++) 
				       XX[i][j]+=MX[start1+djj][i]*InvFixCov[dii][djj][dkk]*MX[start1+dkk][j];
					XY[i]+=MX[start1+djj][i]*InvFixCov[dii][djj][dkk]*VY[start1+dkk];
				}
			}/* dkk */ 
 		
	}/* k */ 
	
 
	
    iv(XX,NXP);
    
	
	for(i=1;i<=NXP;i++){
		beta[i]=0.0;
		for(j=1;j<=NXP;j++)
			beta[i]+=XX[i][j]*XY[j];
	}
	
    free_dmatrix(XX, 1, NXP, 1, NXP);
	free_dvector(XY, 1, NXP);
	
 
	for(i=1;i<=TotalPoint;i++){
	 	residual[i]=VY[i]; 
		for(j=1;j<=NXP;j++)
			residual[i]+=-MX[i][j]*beta[j];			 
		}
 
	
	sigma2[1]=0.0; 
	for(k=1; k<=TotalSub; k++){
		if(k==1){
			start1=0;
			end1=NoEachSub[k];
		}else{
			start1+=NoEachSub[k-1];
			end1+=NoEachSub[k];
		} 
		for (djj=1; djj<=NoEachSub[k]; djj++) 
			for (dkk=1; dkk<=NoEachSub[k]; dkk++)  
       	      sigma2[1]+=residual[start1+djj]*InvFixCov[k][djj][dkk]*residual[start1+dkk];			 		
	}/* k */ 
	sigma2[1]=sigma2[1]/(TotalPoint*1.0); 
	
  
	
 
	
 	
	 //	cout<<sigma2[1]<<endl;
	//	cout<<"(Iterations) "<<item<<endl; 
	
	
	
}/* EMlinearMixedAR1 */ 


void EMlinearMixedCaseAR1(int hongtu, double **MX, double *VY, int *NoEachSub, int TotalSub, int TotalPoint, int NXP, double *beta, double *sigma2, double ***InvFixCov)
{
	
	
 	int i, j, k, l, dii, djj, dkk, start1, end1, mi, NOdelte;
	double *XY, **XX, *residual; 
	int *deleteOBS;
 
	
  
 
 
	
	deleteOBS=ivector(1, TotalPoint); 
	residual=dvector(1, TotalPoint); 
 	XX =  dmatrix(1, NXP, 1, NXP);
	XY =  dvector(1, NXP); 
	
	mi=1;
	NOdelte=0; 
	for(i=1; i<=TotalSub; i++){
	    for(j=1; j<=NoEachSub[i]; j++){
			if(i==hongtu)
				deleteOBS[mi]=1;
			else
				deleteOBS[mi]=0;
			NOdelte+=deleteOBS[mi]; 
		    mi++; 	
		}
	}
	
	
    for(i=1; i<=NXP; i++){
		XY[i]=0.0;
		for(j=1; j<=NXP; j++) 
			XX[i][j]=0.0;
	} 		
	
	
	for(k=1; k<=TotalSub; k++){
		if(k==1){
			start1=0;
			end1=NoEachSub[k];
		}else{
			start1+=NoEachSub[k-1];
			end1+=NoEachSub[k];
		} 
		for (djj=1; djj<=NoEachSub[k]; djj++) 
			for (dkk=1; dkk<=NoEachSub[k]; dkk++)
			  if(deleteOBS[start1+djj]<=0&&deleteOBS[start1+dkk]<=0){ 
				for(i=1; i<=NXP; i++){ 
					for(j=1; j<=NXP; j++) 
						XX[i][j]+=MX[start1+djj][i]*InvFixCov[k][djj][dkk]*MX[start1+dkk][j];
					XY[i]+=MX[start1+djj][i]*InvFixCov[k][djj][dkk]*VY[start1+dkk];
				}
			}/* dkk */ 
 		
	}/* k */ 
	iv(XX,NXP);
    
	for(i=1;i<=NXP;i++){
		beta[i]=0.0;
		for(j=1;j<=NXP;j++)
			beta[i]+=XX[i][j]*XY[j];
	}
	
    free_dmatrix(XX, 1, NXP, 1, NXP);
	free_dvector(XY, 1, NXP);
	
	for(i=1;i<=TotalPoint;i++){
	 	residual[i]=VY[i]; 
		for(j=1;j<=NXP;j++)
			residual[i]+=-MX[i][j]*beta[j];			 
	}
	
	
	sigma2[1]=0.0; 
	for(k=1; k<=TotalSub; k++){
		if(k==1){
			start1=0;
			end1=NoEachSub[k];
		}else{
			start1+=NoEachSub[k-1];
			end1+=NoEachSub[k];
		} 
		for (djj=1; djj<=NoEachSub[k]; djj++) 
			for (dkk=1; dkk<=NoEachSub[k]; dkk++)  
				  if(deleteOBS[start1+djj]<=0&&deleteOBS[start1+dkk]<=0)
					  sigma2[1]+=residual[start1+djj]*InvFixCov[k][djj][dkk]*residual[start1+dkk];			 		
	}/* k */ 
	sigma2[1]=sigma2[1]/(TotalPoint*1.0-NOdelte); 
	
	
 	
	free_ivector(deleteOBS, 1, TotalPoint); 
	free_dvector(residual, 1, TotalPoint); 

	
	//	cout<<sigma2[1]<<" "<<sigma2[2]<<endl;
	//	cout<<"(Iterations) "<<item<<endl; 
	
	
}/* EMlinearMixedCaseAR1 */ 



void SimulateLMMAR1(int TotalSub, int* NoEachSub, double* mean, double* truesigma2, double* VYY, double ***FixCov)
{
	int dii, djj, dkk, start, end;
 	double tempt, **multvv; 
	
	
	for(dii=1; dii<=TotalSub; dii++){
		multvv=dmatrix(1, 1, 1, NoEachSub[dii]); 
		if(dii==1){
			start=0; 
			end=NoEachSub[dii]; 
		} 
		else{ 
			start+=NoEachSub[dii-1]; 
			end+=NoEachSub[dii]; 
		} 
	 
		
 	    multinor(1, NoEachSub[dii], FixCov[dii], multvv); 
		
		for(djj=start+1; djj<=end; djj++) 
			VYY[djj]=mean[djj]+multvv[1][djj-start]; 
		
	 				
		free_dmatrix(multvv, 1, 1, 1, NoEachSub[dii]); 
		 
		
	}/* for */ 
	
	
}/* end */ 
 
void multinor(int nn, int kk, double **pp, double **vv){ 
	/* this program is used to generate multinormal distribution */
	/* kk is the dimension of pp, nn is the row number of random matrix vv */
	
	double **INPH, *diag;
	int i, j, k;
	
	INPH=dmatrix(1, kk, 1, kk);
	diag=dvector(1, kk); 
	for(i=1;i<=kk;i++)
        for(j=1;j<=kk;j++)
			INPH[i][j]=pp[i][j];
	
	choldc(INPH, kk, diag);
	for(k=1;k<=kk;k++)
	    for(j=k;j<=kk;j++)
			if(j==k)  
				INPH[k][j]=diag[k];
			else      
				INPH[k][j]=0.0;
	
	for(i=1;i<=nn;i++){
		for(j=1;j<=kk;j++)
            diag[j]=gasdev();    
		for(j=1;j<=kk;j++){
	        vv[i][j]=0.0;
	        for(k=1;k<=kk;k++)
				vv[i][j]+=INPH[j][k]*diag[k]; 
		}
	}
	
	free_dmatrix(INPH, 1, kk, 1, kk);
	free_dvector(diag,1, kk); 
	
}//end     
 
