//#include <malloc.h>
#include <cstdio>
#include <iostream>
#include "nrutil.h"
//# include "pointdef.h"
# include <string>
# include <fstream>
//# include "pxanalyse.h"

using namespace std;
 

#define NR_END 1
#define FREE_ARG char*

void free_lvector(unsigned long *v, int nl, int nh)
/* free an unsigned int vector allocated with lvector() */
{
	free((FREE_ARG) (v+nl-NR_END));
}

unsigned long *lvector(int nl, int nh)
/* allocate an unsigned int vector with subscript range v[nl..nh] */
{
	unsigned long *v;
	v=(unsigned long *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(int)));
	if (!v) nrerror("allocation failure in lvector()");
	return v-nl+NR_END;
}

float ***f3tensor(int nrl, int nrh, int ncl, int nch, int ndl, int ndh)
/* allocate a float 3tensor with range t[nrl..nrh][ncl..nch][ndl..ndh] */
{
	int i,j,nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1;
	float ***t;
/* allocate pointers to pointers to rows */
	t=(float ***) malloc((size_t)((nrow+NR_END)*sizeof(float**)));
	if (!t) nrerror("allocation failure 1 in f3tensor()");
	t += NR_END;
	t -= nrl;
/* allocate pointers to rows and set pointers to them */
	t[nrl]=(float **) malloc((size_t)((nrow*ncol+NR_END)*sizeof(float*)));
	if (!t[nrl]) nrerror("allocation failure 2 in f3tensor()");
	t[nrl] += NR_END;
	t[nrl] -= ncl;
/* allocate rows and set pointers to them */
	t[nrl][ncl]=(float *) malloc((size_t)((nrow*ncol*ndep+NR_END)*sizeof(float)));
	if (!t[nrl][ncl]) nrerror("allocation failure 3 in f3tensor()");

	t[nrl][ncl] += NR_END;
	t[nrl][ncl] -= ndl;
	for(j=ncl+1;j<=nch;j++) t[nrl][j]=t[nrl][j-1]+ndep;
	for(i=nrl+1;i<=nrh;i++) {
		t[i]=t[i-1]+ncol;
		t[i][ncl]=t[i-1][ncl]+ncol*ndep;
	for(j=ncl+1;j<=nch;j++) t[i][j]=t[i][j-1]+ndep;
	}
/* return pointer to array of pointers to rows */
	return t;
}

void nrerror(const char* error_text)
{
//	void exit(int);

	fprintf(stderr,"Numerical Recipes run-time error...\n");
	fprintf(stderr,"%s\n",error_text);
	fprintf(stderr,"...now exiting to system...\n");
	exit(1);
}
 


float *vector(int nl, int nh)
{
	float *v;

	v=(float *)malloc((unsigned) (nh-nl+1)*sizeof(float));
	if (!v) nrerror("allocation failure in vector()");
	return v-nl;
}

int *ivector(int nl, int nh)
{
	int *v;

	v=(int *)malloc((unsigned) (nh-nl+1)*sizeof(int));
	if (!v) nrerror("allocation failure in ivector()");
	return v-nl;
}


unsigned short *usvector(int nl, int nh)
{
	unsigned short *v;

	v=(unsigned short *)malloc((unsigned) (nh-nl+1)*sizeof(unsigned short));
	if (!v) nrerror("allocation failure in ivector()");
	return v-nl;
}

 
double *dvector(int nl, int nh)
{
	double *v;

	v=(double *)malloc((unsigned) (nh-nl+1)*sizeof(double));
	if (!v) nrerror("allocation failure in vector()");
	return v-nl;
}
 


float **matrix(int nrl, int nrh, int ncl, int nch)
{
	int i;
	float **m;

	m=(float **) malloc((unsigned) (nrh-nrl+1)*sizeof(float*));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(float *) malloc((unsigned) (nch-ncl+1)*sizeof(float));
		if (!m[i]) nrerror("allocation failure 2 in matrix()");
		m[i] -= ncl;
	}
	return m;
}

double **dmatrix(int nrl, int nrh, int ncl, int nch)
{
	int i;
	double **m;

	m=(double **) malloc((unsigned) (nrh-nrl+1)*sizeof(double*));
	if (!m) nrerror("allocation failure 1 in dmatrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(double *) malloc((unsigned) (nch-ncl+1)*sizeof(double));
		if (!m[i]) nrerror("allocation failure 2 in dmatrix()");
		m[i] -= ncl;
	}
	return m;
}

int **imatrix(int nrl, int nrh, int ncl, int nch)
{
	int i,**m;

	m=(int **)malloc((unsigned) (nrh-nrl+1)*sizeof(int*));
	if (!m) nrerror("allocation failure 1 in imatrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(int *)malloc((unsigned) (nch-ncl+1)*sizeof(int));
		if (!m[i]) nrerror("allocation failure 2 in imatrix()");
		m[i] -= ncl;
	}
	return m;
}



float **submatrix(float **a, int oldrl, int oldrh, int oldcl, int oldch, int newrl, int newcl)
{
	int i,j;
	float **m;

	m=(float **) malloc((unsigned) (oldrh-oldrl+1)*sizeof(float*));
	if (!m) nrerror("allocation failure in submatrix()");
	m -= newrl;

	for(i=oldrl,j=newrl;i<=oldrh;i++,j++) m[j]=a[i]+oldcl-newcl;

	return m;
}



void free_vector(float *v, int nl, int nh)
{
	free((char*) (v+nl));
}

void free_ivector(int *v, int nl, int nh)
{
	free((char*) (v+nl));
}

void free_dvector(double *v, int nl, int nh)
{
	free((char*) (v+nl));
}


void free_usvector(unsigned short *v, int nl, int nh)
{
 	free((char*) (v+nl));
}



void free_matrix(float **m, int nrl, int nrh, int ncl, int nch)
{
	int i;

	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}

void free_dmatrix(double **m, int nrl, int nrh, int ncl, int nch)
{
	int i;

	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}

void free_imatrix(int **m, int nrl, int nrh, int ncl, int nch)
{
	int i;

	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}



void free_submatrix(float **b, int nrl, int nrh, int ncl, int nch)
{
	free((char*) (b+nrl));
}



float **convert_matrix(float *a,int nrl, int nrh, int ncl, int nch)
{
	int i,j,nrow,ncol;
	float **m;

	nrow=nrh-nrl+1;
	ncol=nch-ncl+1;
	m = (float **) malloc((unsigned) (nrow)*sizeof(float*));
	if (!m) nrerror("allocation failure in convert_matrix()");
	m -= nrl;
	for(i=0,j=nrl;i<=nrow-1;i++,j++) m[j]=a+ncol*i-ncl;
	return m;
}



void free_convert_matrix(float **b,int nrl, int nrh, int ncl, int nch)
{
	free((char*) (b+nrl));
}


double ***dmatrix3(int nrl, int nrh, int ncl, int nch, int n3l, int n3h)
{
  int i, j;
  double ***m;
  void nrerror(const char *);

  m=(double ***) malloc((unsigned) (nrh-nrl+1)*sizeof(double**));
  if (!m) nrerror("error in dmatrix3");
  m -= nrl;
  for(i=nrl; i<=nrh;i++) {
    m[i]=(double **) malloc((unsigned) (nch-ncl+1)*sizeof(double*));
    if (!m[i]) nrerror("error in dmatrix3");
    m[i] -= ncl;
    for(j=ncl; j<=nch; j++){
      m[i][j]=(double *) malloc((unsigned) (n3h-n3l+1)*sizeof(double));
      if (!m[i][j]) nrerror("error in dmatrix3");
	  m[i][j] -= n3l;
    }      
  }
  return m;
}


void free_dmatrix3(double ***m, int nrl, int nrh, int ncl, int nch, int n3l, int n3h) 
{
	int i,j;
	for(i=nrh;i>=nrl;i--)
   	   for(j=nch;j>=ncl;j--)
		free((char*) (m[i][j]+n3l));
	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}




float ***fmatrix3(int nrl, int nrh, int ncl, int nch, int n3l, int n3h)
{
  int i, j;
  float ***m;

  m=(float ***) malloc((unsigned) (nrh-nrl+1)*sizeof(float**));
  if (!m) nrerror("error in fmatrix3");
  m -= nrl;
  for(i=nrl; i<=nrh;i++) {
    m[i]=(float **) malloc((unsigned) (nch-ncl+1)*sizeof(float*));
    if (!m[i]) nrerror("error in dmatrix3");
    m[i] -= ncl;
    for(j=ncl; j<=nch; j++){
      m[i][j]=(float *) malloc((unsigned) (n3h-n3l+1)*sizeof(float));
      if (!m[i][j]) nrerror("error in dmatrix3");
	  m[i][j] -= n3l;
    }      
  }
  return m;
}


void free_fmatrix3(float ***m, int nrl, int nrh, int ncl, int nch, int n3l, int n3h) 
{
	int i,j;
	for(i=nrh;i>=nrl;i--)
   	   for(j=nch;j>=ncl;j--)
		free((char*) (m[i][j]+n3l));
	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}



float ****fmatrix4(int nrl, int nrh, int ncl, int nch, int n3l, int n3h, int n4l, int n4h)
{
  int i, j, k;
  float ****m;

  m=(float ****) malloc((unsigned) (nrh-nrl+1)*sizeof(float***));
  if (!m) nrerror("error in fmatrix4");
  m -= nrl;
  for(i=nrl; i<=nrh;i++) {
    m[i]=(float ***) malloc((unsigned) (nch-ncl+1)*sizeof(float**));
    if (!m[i]) nrerror("error in fmatrix4");
    m[i] -= ncl;
    for(j=ncl; j<=nch; j++){
      m[i][j]=(float **) malloc((unsigned) (n3h-n3l+1)*sizeof(float*));
      if (!m[i][j]) nrerror("error in fmatrix4");
	  m[i][j] -= n3l;
	  for(k=n3l; k<=n3h; k++){
         m[i][j][k]=(float *) malloc((unsigned) (n4h-n4l+1)*sizeof(float));
         if (!m[i][j][k]) nrerror("error in fmatrix4");
	     m[i][j][k] -= n4l;
	  }
    }      
  }
  return m;
}


void free_fmatrix4(float ****m,int nrl, int nrh, int ncl, int nch, int n3l, int n3h, int n4l, int n4h) 
{
	int i,j, k;
	for(i=nrh;i>=nrl;i--)
   	   for(j=nch;j>=ncl;j--)
		   for(k=n3h; k>=n3l; k--)
		free((char*) (m[i][j][k]+n4l));
	for(i=nrh;i>=nrl;i--)
   	   for(j=nch;j>=ncl;j--)
		free((char*) (m[i][j]+n3l));
	for(i=nrh;i>=nrl;i--) 
		free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}


void free_f3tensor(float ***t, int nrl, int nrh, int ncl, int nch,
int ndl, int ndh)
/* free a float f3tensor allocated by f3tensor() */
{
free((FREE_ARG) (t[nrl][ncl]+ndl-NR_END));
free((FREE_ARG) (t[nrl]+ncl-NR_END));
free((FREE_ARG) (t+nrl-NR_END));
}
