#include <cstdio>   
# include <cstdlib> 
# include <cmath>     
# include <iostream>
# include <string>
# include <fstream>

# include "nrutil.h"
# include "functions.h"


//extern unsigned int congrval,tausval;
extern int test;

// if x>0, return x, otherwise 0
double nonneg(double x)
{
	if(x>0.0)
		return x;
	else
		return 0.0;
}


void setSEED(int Y [],int SEED){
	int X[]={21, 14, 49, 0, 1, 2, 32, 22, 36, 23, 28,  3}, size=12, i;
	unsigned int tmp=((SEED-1)%1024)*(int)pow(2.0,22.0);

	for(i=0;i<size;i++)	Y[i]=X[i];	
	for(i=5;i>=3;i--){
		Y[i]=tmp/(int)pow(2.0,6.0*i);
		tmp-=Y[i]*(int)pow(2.0,6.0*i);	}
}

void init1(int seeds[]){
	int i, size=6, ctmp, ttmp;
	ctmp=0;	ttmp=0;
	for(i=0;i<6;i++){
		ctmp+=seeds[i]*((unsigned int)pow(2.0,6.0*i));
		ttmp+=seeds[i+6]*((unsigned int)pow(2.0,6.0*i));	}
	congrval=ctmp;	tausval=ttmp;
}

double s_xuni(void)
{
	unsigned int n, lambda = 69069, res;
	do {
		congrval = congrval * lambda;
		tausval ^= tausval >> 15;
		tausval ^= tausval << 17;
		n = tausval ^ congrval;
		res = (n>>1) & 017777777777;
	} while(res == 0);
	return (res / 2147483648.);
}

void choldc (double **a, int n, double p[])
{
   int i,j,k;
   double sum;

  for(i=1; i<=n; i++){
	 for(j=i; j<=n;j++){
	    for(sum=a[i][j], k=i-1; k>=1; k--)  sum-=a[i][k]*a[j][k];
	       if (i==j){
	         if(sum<=0.0)printf(" choldc failed");
	         p[i]=sqrt(sum);
		   }else a[j][i]=sum/p[i];
	 }
  }
 }

// choleky() function is used in in_wish
void choleky(double **a,int nn,double *p)
{

   int i,j,k;
   double sum;

   for(i=1; i<=nn; i++){
	   for(j=i; j<=nn;j++){
		   for(sum=a[i][j], k=i-1; k>=1; k--) sum-=a[i][k]*a[j][k];
		   if (i==j){
			   if(sum<=0.0) printf("choldc failed");
			   p[i]=sqrt(sum);
		   } else a[j][i]=sum/p[i];
	   }
   }
   for(i=1;i<=nn;i++){
	   for(j=1;j<=nn;j++)
           if(i<j) a[i][j]=0.0;
		   a[i][i]=p[i];
   }
}



double gasdev(void)
 {
	static int iset=0;
	static double gset;
	double fac,r,v1,v2;

	if  (iset == 0) {
		do {
			v1=2.0*s_xuni()-1.0;
			v2=2.0*s_xuni()-1.0;
			r=v1*v1+v2*v2;
		} while (r >= 1.0||r==0.0);
		fac=sqrt(-2.0*log(r)/r);
		gset=v1*fac;
		iset=1;
		return v2*fac;
	} else {
		iset=0;
		return gset;
	}
}/* end */ 


void multinor(int nn, int kk, double **pp, double **vv)
{ 
     double **INPHO=dmatrix(1, kk, 1, kk);
	 double *diagO=dvector(1, kk); 
     int i, j, k;
     
     for(i=1;i<=kk;i++)
        for(j=1;j<=kk;j++)
			INPHO[i][j]=pp[i][j];
  
      choldc(INPHO, kk, diagO);
      for(k=1;k<=kk;k++)
		  for(j=k;j<=kk;j++){
			if(j==k)  INPHO[k][j]=diagO[k];
			else      INPHO[k][j]=0.0;
		  }

     for(i=1;i<=nn;i++){
		// printf("\n Simulating %d-th sample of multinormal distribution!\n", i);
		 for(j=1;j<=kk;j++){
		//	 cout << j;
			 diagO[j]=gasdev();
		//	 cout << j<<diagO[j];
		//	 printf("\n diag0[%d]=%f", j, diagO[j]);
		 }
		 //printf("\n test1!\n");
         for(j=1;j<=kk;j++){
	        vv[i][j]=0.0;
			for(k=1;k<=kk;k++){
				vv[i][j]+=INPHO[j][k]*diagO[k];  
				//printf("\n test2!\n");
			}
			//printf("\n vv[%d][%d]=%f", i, j, vv[i][j]);
		 }
	 }
     free_dmatrix(INPHO, 1, kk, 1, kk); 	 free_dvector(diagO,1, kk); 
 }   


void ludcmp(double **a, int n, int *indx) 
{
	int i, imax, j, k;
	double big, dum, sum, temp, *vv, TINY;

    TINY=1.0e-20;
	vv=dvector(1,n);
	for (i=1;i<=n;i++) {
		big=0.0;
		for (j=1;j<=n;j++)
			if ((temp=fabs(a[i][j])) > big) big=temp;
		if (big == 0.0) nrerror("Sigmatrix in ludcmp") ;
		vv[i]=1.0/big;
	}
	for (j=1;j<=n;j++) {
		for (i=1;i<j;i++) {
			sum=a[i][j];
			for (k=1;k<i;k++) sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
		}
		big=0.0;
		for (i=j;i<=n;i++) {
			sum=a[i][j];
			for (k=1;k<j;k++)
				sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
			if ( (dum=vv[i]*fabs(sum)) >= big) {
				big=dum;
				imax=i;
			}
		}
		if (j != imax) {
			for (k=1;k<=n;k++) {
				dum=a[imax][k];
				a[imax][k]=a[j][k];
				a[j][k]=dum;
			}
			vv[imax]=vv[j];
		}
		indx[j]=imax;
		if (a[j][j] == 0.0) a[j][j]=TINY;
		if (j != n) {
			dum=1.0/(a[j][j]);
			for (i=j+1;i<=n;i++) a[i][j] *= dum;
		}
	}
	free_dvector(vv,1,n);
}
 
void lubksb(double **a, int n, int *indx, double *b)
{
	int i,ii=0,ip,j;
	double sum;

    for (i=1;i<=n;i++) {
		ip=indx[i];
		sum=b[ip];
		b[ip]=b[i];
		if (ii)
			for (j=ii;j<=i-1;j++) sum -= a[i][j]*b[j];
		else if (sum) ii=i;
		b[i]=sum;
	}
	for (i=n;i>=1;i--) {
		sum=b[i];
		for (j=i+1;j<=n;j++) sum -= a[i][j]*b[j];
		b[i]=sum/a[i][i];
	}
}

void invv(double **fma, int nn)  /* any nn x nn matrix's inverse */ 
{
	int  i, j, k, *indxx;
	double *COLx, **ipix;

	indxx=ivector(1, nn); 	COLx=dvector(1, nn); 	ipix=dmatrix(1, nn, 1, nn);
	ludcmp(fma, nn, indxx);	
	for(i=1; i<=nn; i++){
		for(j=1; j<=nn; j++) COLx[j]=0.0;
		COLx[i]=1.0;		
		lubksb(fma, nn, indxx, COLx); 		
		for(j=1; j<=nn; j++) ipix[j][i]=COLx[j];
	}
	for(k=1; k<=nn; k++)
		for(i=1; i<=nn; i++) fma[k][i]=ipix[k][i];

	free_ivector(indxx, 1, nn);	free_dvector(COLx, 1, nn);	free_dmatrix(ipix, 1, nn, 1, nn);
 }  


double rgamma (double shape, double rate)
{  // generate gamma distribution with parameters shape and scale Gamma(shape, scale)
   // p(x) = [b^a/G(a)] x^{a-1} exp{-bx}, a=shape, b=rate

   double  b, h, r, g, f, x, r2, d, gamma1=10.0;

   b = shape - 1.0;   
   if (b >=0.0) {
	   h=sqrt(3.0*shape-0.75);
       do {
          do {
             do {
                r=s_xuni();
                g=r*(1.0-r);
             }while(g<=0.0);
             f = (r - 0.5) * h /sqrt(g);
   			 x = b + f;
           } while (x <= 0.0);
   			r2 =s_xuni();
   			d = 64.0*g*g*g*r2*r2;
   			if (d <= 0) {
               gamma1 = x;
               break;
            }
   			if (d*x < (x - 2.0*f*f)) {
                gamma1 = x;
                 break;
            }
       } while (log(d) > 2.0*(b*log(x/b) - f));
       gamma1 = x;
       gamma1 = (1.0 / rate) * gamma1;
   } else if (b < 0.0) {
	   x = rgamma (shape+1.0, 1.0);
	   r = s_xuni();
	   x = x*pow(r, 1.0/shape);
	   gamma1 = x/rate;
   }
   return gamma1;
}  

/* input convariance matrix VG free degree n, and dimension q*/
void in_wish(int q2,int nm, double **VG,double **PHI)
{
  int   i,j,l,k;
  double *uv,**vv,*gg,**W,**inwis;

  uv=dvector(1,q2);  gg=dvector(1,q2); W=dmatrix(1,q2,1,q2);
  vv=dmatrix(1,q2,1,q2);  inwis=dmatrix(1,nm,1,q2);

  for(i=1;i<=q2;i++)uv[i]=0.0;
  for(i=1;i<=q2;i++){
     for(j=1;j<=q2;j++)vv[i][j]=0.0;
     vv[i][i]=1.0;
   }
  multinor(nm,q2,vv,inwis);   
  for(i=1;i<=q2;i++){
     for(j=1;j<=q2;j++){
        W[i][j]=0.0;
        for(l=1;l<=nm;l++) W[i][j]+=inwis[l][i]*inwis[l][j];
      }
    }
  invv(VG,q2);
  choleky(VG,q2,uv);
   
  for(i=1;i<=q2;i++){
      for(j=1;j<=q2;j++){
        vv[i][j]=0.0;
        for(k=1;k<=q2;k++){
          for(l=1;l<=q2;l++)vv[i][j]+=VG[i][k]*W[k][l]*VG[j][l];
        }
     }
    }    
   invv(vv,q2);
   for(i=1;i<=q2;i++){
      for(j=1;j<=q2;j++)PHI[i][j]=vv[i][j];
    }

  free_dvector(uv,1,q2);  free_dvector(gg,1,q2);  free_dmatrix(W,1,q2,1,q2);
  free_dmatrix(vv,1,q2,1,q2);  free_dmatrix(inwis,1,nm,1,q2);
}


// inv_gaussian() generate from Inv-Gaussian(mu, lambda)
// Follow wikipedia: http://en.wikipedia.org/wiki/Inverse_Gaussian_distribution
double inv_gaussian(double mu, double lmd)
{
	double v, x, y, z;

	if(mu<=0){
		printf("\n Error in inverse-Gaussian! mu must be positive!");
		return 0;
	}
	else{
		v = gasdev();
		y = v*v;
		x = mu + (mu*mu*y)/(2*lmd) - (mu/(2*lmd))*sqrt(4*mu*lmd*y+mu*mu*y*y);
		//printf("\n 4*mu*lmd*y+mu*mu*y*y=%f, y=%f", 4*mu*lmd*y+mu*mu*y*y, y);
		z = s_xuni();
		if(z<=(mu/(mu+x)))
			return x;
		else
			return mu*mu/x;
	}

} //End of inv_gaussian()

// rexp() generate from exponential distribution with mean a
// Follow wikepedia: http://en.wikipedia.org/wiki/Exponential_distribution
double rexp(double a)
{
	double	u, t;

	u = s_xuni();
	t = -log(1-u)/a;

	return t;
}

// rtrnorm0() simulate from right truncated standard normal distribution
// That is, x ~ N(mu, s2)*I(x>a)
// Follow Robert (2009): Simulation of truncated normal variables
double rtrnorm(double a, double mu, double std)
{
	int count=0;
	double u=1e5, z, x, p=0.0, a0, a1;

	a1 = (a-mu)/std;
	a0 = (a1+sqrt(a1*a1+4.0))/2.0;
	while(u>p){
		z = rexp(a0) + a1;
		p = exp(-(a0-z)*(a0-z)/2);
		u = s_xuni();
		count++;
		if(count>1e6){	
			printf("\n Error in rtrnorm! Dead loop!");
			printf("\n a=%f, mu=%f, std=%f.", a, mu, std);
			printf("\n Test! Enter an interger:");
			scanf("%d", &test);
		}
	}
	x = z*std + mu;
	return x;
}


// ltrnorm() simulate from left truncated standard normal distribution
// That is, x ~ N(mu, s2)*I(x<b)
// This is equivalent to simulate -x ~ N(-mu, s2)I(-x>-b)
double ltrnorm(double b, double mu, double std)
{
	double x;
	x = rtrnorm(-b, -mu, std);
	return -x;
}


// rtrnorm0() simulate from right truncated standard normal distribution by definition
// That is, x ~ N(mu, s2)*I(x>a)
// This does not work when a is too large relative to mu
double rtrnorm0(double a, double mu, double std)
{
	int count=0;
	double x=-1e10;

	while(x<=a){
		x = mu + gasdev()*std; 
		count++;
		if(count>1e6){	
			printf("\n Error in rtrnorm0! Dead loop!");
			printf("\n a=%f, mu=%f, std=%f.", a, mu, std);
		}
	}
	return x;
}

// ltrnorm0() simulate from left truncated standard normal distribution by definition
// That is, x ~ N(mu, s2)*I(x<b)
// This does not work when b is too small relative to mu
double ltrnorm0(double b, double mu, double std)
{
	int count=0;
	double x=1e10;

	while(x>=b){
		x = mu + gasdev()*std; 
		count++;
		if(count>1e6){	
			printf("\n Error in ltrnorm0! Dead loop!");
			printf("\n b=%f, mu=%f, std=%f.", b, mu, std);
		}
	}
	return x;
}


// trnorm() simulate from truncated standard normal distribution 
// That is, x ~ N(0, 1)*I(a, b)
double trnorm(double a, double b)
{
	int	count = 0;
	double u=0.0, z, fz=-1.0;

	while(u>fz){
		count++;
		if(count>1e6){	
			printf("\n Error in trnorm! Dead loop!");
			printf("\n a=%f, b=%f, z=%f, fz=%f, u=%f.", a, b, z, fz, u);
		}
		z = a + (b-a)*s_xuni();
		
		if(a<=0 && b>=0)
			fz = exp(-z*z/2);
		else if(b<0)
			fz = exp((b*b-z*z)/2);
		else if(a>0)
			fz = exp((a*a-z*z)/2);
		u = s_xuni();
		//printf("\n a=%f, b=%f, z=%f, fz=%f, u=%f.", a, b, z, fz, u);

		if(u<=fz)
			return z;
	}

} // End of trnorm()


// trnorm() simulate from truncated N(mu, s2)
// That is, x ~ N(mu, s2)*I(a', b')
double trnorm(double mu, double s, double a, double b)
{
	double x, a0, b0;

	a0 = (a-mu)/s;
	b0 = (b-mu)/s;
	x = mu+trnorm(a0, b0)*s;

	return x;
} // End of trnorm()



/*	File:	pnorm() is obtained from CDF.cpp by Christer Karlsson

This code implements a function that calculates the 
standard normal CDF (x), using an approximation from 
Abromowitz and Stegun Handbook of Mathematical Functions.

http://www.math.sfu.ca/~cbm/aands/page_932.htm 

   CDF(x) = 1-Z(x)*(b1*t+b2*t^2+b3*t^3+b4*t^4+b5*t^5)+err
            (Where |err| < 7.5x10^-8)    
	    
        t =  1/(1+p*x)

       b1 =  0.319381530
       b2 = -0.356563782
       b3 =  1.781477937
       b4 = -1.821255978
       b5 =  1.330274429
       p  =  0.2316419

Allowed inputs are doubles. The program breaks with ctrl-C   */

// Functions
// The Gaussian p.d.f with mean = 0 and stddev = 1
double dnorm(const double x)
{
	return (1/sqrt(2*PI))*exp(-x*x/2.0 );
}

double pnorm(const double x)
{
  const double b1 =  0.319381530;
  const double b2 = -0.356563782;
  const double b3 =  1.781477937;
  const double b4 = -1.821255978;
  const double b5 =  1.330274429;
  const double p  =  0.2316419;

  if(x >= 0.0) {
      double t = 1.0 / (1.0 + p*x);
      return (1.0 - dnorm(x)*t*(t*(t*(t*(t*b5 + b4) + b3) + b2) + b1));
  } 
  else { 
      double t = 1.0 / ( 1.0 - p * x );
      return ( dnorm(x)*t*(t*(t*(t*(t*b5 + b4) + b3) + b2) + b1));
  }
} //End of pnorm()



//===========================================================================
//=  Modified version of function in 'genbinomial.c'                        =
//=  Function to generate Binomial distributed random variables             =
//=    - Input:  p and n                                                    =
//=    - Output: Returns with Binomial distributed random variable          =
//===========================================================================
int rbinom(int n, double p)
{
  int    bin_value;             // Computed Poisson value to be returned
  int    i;                     // Loop counter
  // Generate a binomial random variate
  bin_value = 0;
  for (i=0; i<n; i++)
    if (s_xuni() < p) bin_value++;
  return(bin_value);
}




// cbind() combine matrices by column
void cbind(double **M12, int nr, double **M1, int nc1, double **M2, int nc2)
{
	int i, j;
	for(i=1; i<=nr; i++){
		for(j=1; j<=nc1; j++)	
			M12[i][j] = M1[i][j];
		for(j=1; j<=nc2; j++)
			M12[i][j+nc1] = M2[i][j];
	}

} // End of cbind()




void dmatrixtranspose(double **A,int row,int column, double **B)
{ 
	int i,j;

     for (i=1;i<=column;i++)
		for (j=1;j<=row;j++)
			B[i][j]=0;

	for(i=1;i<=row;i++)
	   for (j=1;j<=column;j++){
           B[j][i]=A[i][j];
	   }

}


void dmatrixmultiply (double **A, int row1,int column1, double **B, int row2,int column2,double **AB)
{
	int i,j,m;

	for (i=1;i<=row1;i++)
		for (j=1;j<=column2;j++)
			AB[i][j]=0;

	for (i=1;i<=row1;i++)
		for (j=1;j<=column2;j++)
			for (m=1;m<=column1;m++){
				AB[i][j]+=A[i][m]*B[m][j];
			}
}


void dmatrixmultiply (double **A, int row1,int column1, double *B, double *AB)
{
	int i,j;

	for (i=1;i<=row1;i++){
		AB[i]=0;
		for (j=1;j<=column1;j++)
			AB[i] += A[i][j]*B[j];
	}
			
}


void dmatrixmultiply (double *A, double **B, int row2,int column2, double *AB)
{
	int i,j;
	
	for (j=1;j<=column2;j++){
		AB[j]=0;
		for (i=1;i<=row2;i++)
			AB[j] += A[i]*B[i][j];
	}
			
}

void dmatrixeq(double **A, int nrow, int ncol, double **B)
{
	int i, j;
	for(i=1; i<=nrow; i++)
		for(j=1; j<=ncol; j++)
			B[i][j] = A[i][j];
}


// sum of all vector elements
int sum(int *v, int length)
{
	int i;
	int s=0;

	for(i=1; i<=length; i++)
		s += v[i];
	return s;
}

// sum of all vector elements
double sum(double *v, int length)
{
	int i;
	double s=0.0;

	for(i=1; i<=length; i++)
		s += v[i];
	return s;
}


// sum of all matrix elements
double sum(double **m, int nrow, int ncol)
{
	int i, j;
	double s=0.0;

	for(i=1; i<=nrow; i++)
		for(j=1; j<=nrow; j++)
			s += m[i][j];

	return s;
}

// create zero matrix
float** zeromatrix(int nrow, int ncol)
{
	int			i, j;
	float**		A=matrix(1, nrow, 1, ncol);
	for(i=1; i<=nrow; i++)
		for(j=1; j<=ncol; j++)
			A[i][j] = 0.0;
	return	A;
}

// create zero vector
float* zerovector(int nrow)
{
	int			i;
	float*		A=vector(1, nrow);
	for(i=1; i<=nrow; i++)
		A[i]= 0.0;
	return	A;
}



// create zero matrix
double** zerodmatrix(int nrow, int ncol)
{
	int			i, j;
	double**	A=dmatrix(1, nrow, 1, ncol);
	for(i=1; i<=nrow; i++)
		for(j=1; j<=ncol; j++)
			A[i][j] = 0.0;

	return	A;
}

// create zero matrix
double*** zerodmatrix3(int dim1, int nrow, int ncol)
{
	int			i, j, k;
	double***	A=dmatrix3(1, dim1, 1, nrow, 1, ncol);
	
	for(i=1; i<=dim1; i++)
		for(j=1; j<=nrow; j++)
			for(k=1; k<=ncol; k++)
				A[i][j][k] = 0.0;
	return	A;
}

// create zero vector
double* zerodvector(int nrow)
{
	int			i;
	double*		A=dvector(1, nrow);
	for(i=1; i<=nrow; i++)
		A[i]= 0.0;
	return	A;
}


// create zero matrix
int** zeroimatrix(int nrow, int ncol)
{
	int		i, j;
	int**	A=imatrix(1, nrow, 1, ncol);
	for(i=1; i<=nrow; i++)
		for(j=1; j<=ncol; j++)
			A[i][j] = 0;

	return	A;
}

// create zero vector
int* zeroivector(int nrow)
{
	int			i;
	int*		A=ivector(1, nrow);
	for(i=1; i<=nrow; i++)
		A[i]= 0;
	return	A;
}


// Create a diagonal matrix with given vector of diagonal elements
double** diag(double *d, int nrow)
{
	int			i, j;
	double**	D=zerodmatrix(nrow, nrow);

	for(i=1; i<=nrow; i++)
		D[i][i] = d[i];
	return D; 
}




// Print a matrix
// row or col of the matrix must be defined from 1
void dmatrixprint(double **AA,int Nrow,int Ncol)
{
	int dii, djj;
	printf("\n");
	for (dii=1;dii<=Nrow;dii++){
		for(djj=1;djj<=Ncol;djj++){
			printf("%f,",AA[dii][djj]);
		}
		printf("\n");
	}
}

void matrixprint(float **AA,int Nrow,int Ncol)
{
	int dii, djj;
	printf("\n");
	for (dii=1;dii<=Nrow;dii++){
		for(djj=1;djj<=Ncol;djj++){
			printf("%f,",AA[dii][djj]);
		}
		printf("\n");
	}
}


void imatrixprint(int **AA,int Nrow,int Ncol)
{
	int dii, djj;
	printf("\n");
	for (dii=1;dii<=Nrow;dii++){
		for(djj=1;djj<=Ncol;djj++){
			printf("%d,",AA[dii][djj]);
		}
		printf("\n");
	}
}


// Print a vector
// row of the vector must be defined from 1
void dvectorprint(double *AA,int Nrow){
	int dii;
	printf("\n");
	for (dii=1;dii<=Nrow;dii++){
			printf("\n %f",AA[dii]);
	}
	printf("\n");
}


void vectorprint(float *AA,int Nrow){
	int dii;
	printf("\n");
	for (dii=1;dii<=Nrow;dii++){
			printf("\n%f",AA[dii]);
	}
	printf("\n");
}

void ivectorprint(int *AA,int Nrow)
{
	int dii;
	printf("\n");
	for (dii=1;dii<=Nrow;dii++){
			printf("%d \t",AA[dii]);
	}
	printf("\n");
}


// min(a, b)
double min(double a, double b)
{
	if(a<b) return a;
	else return b;
}


void indexx(int n, double arrin[], int indx[])
{
	int l,j,ir,indxt,i;
	double q;

	for (j=1;j<=n;j++) indx[j]=j;
	l=(n >> 1) + 1;
	ir=n;
	for (;;) {
		if (l > 1)
			q=arrin[(indxt=indx[--l])];
		else {
			q=arrin[(indxt=indx[ir])];
			indx[ir]=indx[1];
			if (--ir == 1) {
				indx[1]=indxt;
				return;
			}
		}
		i=l;
		j=l << 1;
		while (j <= ir) {
			if (j < ir && arrin[indx[j]] < arrin[indx[j+1]]) j++;
			if (q < arrin[indx[j]]) {
				indx[i]=indx[j];
				j += (i=j);
			}
			else j=ir+1;
		}
		indx[i]=indxt;
	}
}/* end */ 



double round(double x)
{
	int i;
	double d;

	i = floor(x);
	d = x-i;
	if(d>.5)
		return i+1;
	else
		return i*1.0;
} // End of round

// Calculate mean of a given vector vv
double mean(double *vv, int length)
{
	int i;
	double mm=0.0;
	for(i=1; i<=length; i++)
		mm += vv[i];
	mm /= (1.0*length); 
	return mm;
} //End of mean()

// Calculate mean of matrix A for each row (byrow=1) or for each column (byrow=2)
void mean(double *meanA, double **A, int nrow, int ncol, int byrow)
{
	int i, j;

	if(byrow==1){
		for(i=1; i<=nrow; i++){
			meanA[i] = 0.0;
			for(j=1; j<=ncol; j++)
				meanA[i] += A[i][j];
			meanA[i] /= (1.0*ncol); 
		}
	}else{
		for(j=1; j<=ncol; j++){
			meanA[j] = 0.0;
			for(i=1; i<=nrow; i++)
				meanA[j] += A[i][j];
			meanA[j] /= (1.0*nrow); 
		}
	}
} //End of mean


// Calculate stdm of matrix A for each row (byrow=1) or for each column (byrow=2)
void stdm(double *stdA, double **A, int nrow, int ncol, int byrow)
{
	int i, j;
	if(byrow==1){
		double* avgA = dvector(1, nrow);
		mean(avgA, A, nrow, ncol, byrow);
		for(i=1; i<=nrow; i++){
			stdA[i] = 0.0;
			for(j=1; j<=ncol; j++)
				stdA[i] += pow((A[i][j]-avgA[i]), 2);
			stdA[i] /= (1.0*ncol-1.0); 
			stdA[i] = sqrt(stdA[i]);
		}
		free_dvector(avgA, 1, nrow);
	}else{
		double* avgA = dvector(1, ncol);
		mean(avgA, A, nrow, ncol, byrow);
		for(j=1; j<=ncol; j++){
			stdA[j] = 0.0;
			for(i=1; i<=nrow; i++)
				stdA[j] += pow((A[i][j]-avgA[j]), 2);
			stdA[j] /= (1.0*nrow-1.0); 
			stdA[j] = sqrt(stdA[j]);
		}
		free_dvector(avgA, 1, ncol);
	}
} //End of stdm



void MeanbyCol(double *meanA, double **A, int nrow, int ncol)
{
	int i, j;

	for(j=1; j<=ncol; j++){
		meanA[j] = 0.0;
		for(i=1; i<=nrow; i++)
			meanA[j] += A[i][j];
		meanA[j] /= (1.0*nrow); 
	}
} //End of MeanbyCol

void StdbyCol(double *stdA, double **A, int nrow, int ncol)
{
	int i, j;
	double* avgA = dvector(1, ncol);

	MeanbyCol(avgA, A, nrow, ncol);
	for(j=1; j<=ncol; j++){
		stdA[j] = 0.0;
		for(i=1; i<=nrow; i++)
			stdA[j] += pow((A[i][j]-avgA[j]), 2);
		stdA[j] /= (1.0*nrow-1.0); 
		stdA[j] = sqrt(stdA[j]);
	}
	free_dvector(avgA, 1, ncol);
} //End of StdbyCol

// scale() centers a matrix A for each of its column
void scale(double **centerA, double **A, int nrow, int ncol, double *meanA, double *stdA, bool bycol)
{
	int i, j;

	for(j=1; j<=ncol; j++){
		for(i=1; i<=nrow; i++){
			if(bycol)
				centerA[i][j] = (A[i][j] - meanA[j])/stdA[j];
			else
				centerA[i][j] = (A[i][j] - meanA[i])/stdA[i];
		}
	}
} //End of scale()


//////////////////////////////////////////////////////
// Function to write a matrix into a .txt file
/////////////////////////////////////////////////////
 
void savetxt(double **A, int nrow, int ncol, char *filename)
{
	int i, j;

	FILE*   out=fopen(filename, "w");
	for(i=1; i<=nrow; i++){
		for(j=1; j<=ncol; j++)
			fprintf(out, "%10.4f\t", A[i][j]);
		fprintf(out, "\n");
	}
	fclose(out);

}





////////////////////////////////////////////////////////////////////////
// Function to calculate the Estimated Potential Scale Reduction (EPSR)
////////////////////////////////////////////////////////////////////////
// Given k MCMC chains from k different starting values
// EPSR is a measure of MCMC convergency (Gelman, 1996)
// Input: para = k*l matrix of k MCMC chains of length l; k=nrow, l=ncol;
double EPSR(double** para, int k, int l)
{
	int i, j;
	double B, W, mm, sk2, var, epsr;
	double*	meanki=zerodvector(k);

	if(l<10)
		printf("\n Error: length of each MCMC chain must be at least 10!"); 
	mean(meanki, para, k, l, 1);
	mm=mean(meanki, k);
	//if(l>10){
	//	cout << "\n mm=" << mm; 
	//	printf("\n chain=%d, m=%d", k, l); 
	//	printf("\n meanki=: \n");	dvectorprint(meanki, k);
	//	//printf("\n para=: \n");	dmatrixprint(para, k, l);
	//	printf("\n Test! Enter an interger:");
	//	scanf("%d", &test);
	//}

	B=0.0; W=0.0; 
	for(i=1; i<=k; i++){
		B += (meanki[i]-mm)*(meanki[i]-mm);
		sk2=0.0;
		for(j=1; j<=l; j++)
			sk2 += (para[i][j]-meanki[i])*(para[i][j]-meanki[i]);
		sk2 /= (1.0*(l-1));
		W += sk2; 
	}
	B = (1.0*l)*B/(1.0*k-1.0);
	W = 1.0*(1.0/k)*W;
	var = ((1.0*(l-1))*W+B)/(1.0*l);
	//printf("\n W=%f, B=%f, var=%f", W, B, var);
	if(W>0.0)
		epsr = sqrt(var/W); 
	else{
		if(B==0.0)
			epsr = 0.0;
		else
			printf("\n Error: W=0.0, but B>0.0!");
	}	
	free_dvector(meanki, 1, k);
	return epsr; 	

} // End of EPSR
