#ifndef FUNCTIONS_H
#define FUNCTIONS_H

# include <cstdlib>  
# include <cmath>
# include <iostream>
# include <string>
# include <fstream>
# include "nrutil.h"


//using namespace std;
extern unsigned int congrval,tausval;

double	nonneg(double x);
void    setSEED(int Y[],int SEED);
void    init1(int seeds[]);
double  s_xuni(void);
void    choldc (double **a, int n, double *p); 
void	choleky(double **a,int nn,double *p);
void    indexx(int n, double arrin[], int indx[]);
double  gasdev(void); 
void    ludcmp(double **a,int n,int *indx); 
void    lubksb(double **a, int n, int *indx, double *b);
void    invv(double **fma, int nn);   

void    multinor(int n, int m, double **vv, double **vt); 
double  rgamma (double shape, double rate);
void    in_wish(int q2,int nm, double **VG,double **PHI);
double	inv_gaussian(double mu, double lmd);
double	dnorm(const double x);
double	pnorm(const double x);
double	trnorm(double a, double b);
double	trnorm(double mu, double s, double a, double b);
double	rexp(double a);
double	ltrnorm(double b, double mu, double std);
double	rtrnorm(double a, double mu, double std);
double	ltrnorm0(double b, double mu, double std);
double	rtrnorm0(double a, double mu, double std);
int		rbinom(int n, double p);

// Matrix manipulation
double** diag(double *d, int nrow);
float*	zerovector(int nrow);
double* zerodvector(int nrow);
int*	zeroivector(int nrow);
int**	zeroimatrix(int nrow, int ncol);
float** zeromatrix(int nrow, int ncol);
double** zerodmatrix(int nrow, int ncol);
double*** zerodmatrix3(int dim1, int nrow, int ncol);
void	ivectorprint(int *AA,int Nrow);
void	vectorprint(float *AA,int Nrow);
void	dvectorprint(double *AA,int Nrow);
void	imatrixprint(int **AA,int Nrow,int Ncol);
void	matrixprint(float **AA,int Nrow,int Ncol);
void	dmatrixprint(double **AA,int Nrow,int Ncol);
void	cbind(double **M12, int nr, double **M1, int nc1, double **M2, int nc2);
void	dmatrixtranspose(double **A,int row,int column, double **B);
void	dmatrixmultiply (double **A, int row1,int column1, double *B, double *AB);
void	dmatrixmultiply (double *A, double **B, int row2,int column2, double *AB);
void	dmatrixmultiply(double **A, int row1,int column1, double **B, int row2,int column2,double **AB);
void	dmatrixeq(double **A, int nrow, int ncol, double **B);
int		sum(int *v, int length);
double	sum(double *v, int length);
double	sum(double **m, int nrow, int ncol);
double	min(double a, double b);
double	round(double x);
double	mean(double *vv, int length);
void	mean(double *meanA, double **A, int nrow, int ncol, int byrow);
void	stdm(double *stdA, double **A, int nrow, int ncol, int byrow);
void	scale(double **centerA, double **A, int nrow, int ncol, double *meanA, double *stdA, bool bycol);



// Function to write a matrix into a .txt file
void	savetxt(double **A, int nrow, int ncol, char *filename);

//Function to calculate the Estimated Potential Scale Reduction (EPSR)
double	EPSR(double** para, int k, int l);


#endif;