////////////////////////////////////////// 
// BLasso for SSEM
// By Ruixin Guo, last updated June 2011
////////////////////////////////////////// 

# include <cstdio>   
# include <cmath>    
# include <iostream>
# include <string> 
# include <fstream>   
# include "nrutil.h"
# include "functions.h"
# include "sem.h"

using namespace std;
unsigned int congrval,tausval;

/////////////////////////////////////////////////////////////////////////////
// Constants and global variables
// NN = n; NP = p; NQ = q; NQ1 = q1; NQ2 = q2; NX = s; NT = t; Nr = r;
// NST = NQ1+NX+NT = q1+s+t
// penalize=1 is for normal prior case without penalization
/////////////////////////////////////////////////////////////////////////////
int NN, NP, NQ, NQ1, NQ2, NX, NT, Nr, NST, NY;
int	NK, NF, R, Nlassolmd;	 
int	test, testprint=1, standardize=1;
double**	Knots;

// penalize=1 is for normal prior case without penalization
// updatey1=1 is for the case with ordered categorical data
// standardize=1 is for the case standardizing the structural equation for lasso
// standardize=1 generates initial MCMC chain for standardizing SE


int main()
{
	int i, j, g, gi, k, m, r;	// R = number of MCMC chains 
	int maxbk, maxpara, Ndlmd;
	int seed, SEEDY[12];
	
	seed=28;
    setSEED(SEEDY, seed);
    init1(SEEDY);

	// For Sim5
	NN = 500; NP = 9; NQ = 3; NQ1=1; NQ2 = 2; Nr = 9; NX = 3; NK = 5; NT = 2*NK-1+(NK-1)*(NK-1); 
	NF = 3; maxbk = 4; 
	NST = NQ1+NX+NT; NY = Nr+NQ; maxpara=70; // 64 parameters in Sim5 when NK=5
	Ndlmd=NST; Nlassolmd=3; 	

	int**		indm = zeroimatrix(NP, NY);
	double**	C = dmatrix(1, Nr, 1, NN);			double**	trueAm = zerodmatrix(NP, Nr);
	double**	trueLmd = zerodmatrix(NP, NQ);		
	double**	trueB = dmatrix(1, NQ1, 1, NX);		double**	truePhi = dmatrix(1, NX, 1, NX);
	double**	trueGamma = zerodmatrix(NQ1, NT);	// for the case without spline
	// In the spline case, Gamma is the Beta for the spline coefficient!
	
	double**	truePi = dmatrix(1, NQ1, 1, NQ1);
	double*		truepsi = dvector(1, NP);			double*		truepsz = dvector(1, NQ1);
	double**	Xt = dmatrix(1, NN, 1, NX);			double**	X = dmatrix(1, NX, 1, NN);
	double**	trueLmdy = dmatrix(1, NP, 1, NY);	double**	trueKsi = dmatrix(1, NN, 1, NQ2);
	double**	trueEta = dmatrix(1, NN, 1, NQ1);	double**	trueOmg = dmatrix(1, NN, 1, NQ);
	int*		ry = ivector(1, NP);	// ry counts the number of unknown parameters in each row of Lmdy
	int**		mindex = zeroimatrix(NP, NY);  // mindex gives the index of the unknown parameter for each row


	// Hyperparameters
	int			rho0;
	double		s2omi;
	double*		a0psi = dvector(1, NP);			double*		b0psi = dvector(1, NP); 
	double*		a0psz = dvector(1, NQ1);		double*		b0psz = dvector(1, NQ1);
	double*		lassor0 = dvector(1, Nlassolmd);		double*		lassodt0 = dvector(1, Nlassolmd);
	double**	H0y = zerodmatrix(NY, NY);
	double**	Phi0 = dmatrix(1, NX, 1, NX);	double**	R0 = dmatrix(1, NX, 1, NX);
	double**	mu0y = dmatrix(1, NP, 1, NY);	double***	h0y = dmatrix3(1, NP, 1, NY, 1, NY);

	// Initial values for MCMC
	double**	Am = zerodmatrix(NP, Nr);		double**	Lmd = zerodmatrix(NP, NQ);
	double**	B = dmatrix(1, NQ1, 1, NX);
	double**	Phi = zerodmatrix(NX, NX);		double**	Gamma = dmatrix(1, NQ1, 1, NT);
	double**	Pi = dmatrix(1, NQ1, 1, NQ1);	double*		psi = dvector(1, NP);
	double*		psz = dvector(1, NQ1);			double**	Lmdy = dmatrix(1, NP, 1, NY);
	double**	Omg = dmatrix(1, NQ, 1, NN);	double**	lassolmd = zerodmatrix(NQ1, Nlassolmd);
	double**	Gy = dmatrix(1, NY, 1, NN);		double**	Lmdom = dmatrix(1, NQ1, 1, NST);
	double**	dlmdom = dmatrix(1, NQ1, 1, Ndlmd);	double**	Y = dmatrix(1, NP, 1, NN);
	double**	trueLmdom = dmatrix(1, NQ1, 1, NST);	
	 


	////////////////
	// MCMC Chains
	////////////////
	// R = # of parallel MCMC chains to evaluate the convergence
	int			M=3000, npar;
	double		burnin=M/2, avgaccept=0.0; 
	double*		accept = zerodvector(NN);
	double*		trueparameters = zerodvector(maxpara);
	double*		allparameters = zerodvector(maxpara);
	double*		meanparameters = zerodvector(maxpara);
	double		**DeltaH, **DeltaHstd, *meanGm, *stdGm;


	////////////////
	// Data Input
	////////////////

	sim(indm, C, trueAm, trueLmd, trueB, truePhi, truePi, 
		truepsi, truepsz, Xt, trueLmdy, trueKsi, trueEta, trueOmg, Y);
	dmatrixtranspose(Xt, NN, NX, X); 
	printf("\n End of Simulation!\n");

	for(k=1; k<=NP; k++){
		i=0;
		ry[k] = sum(indm[k], NY);
		for(j=1; j<=NY; j++){
			if(indm[k][j]){
				i++;
				mindex[k][i] = j;
			}
		}
	}
	for(i=1; i<=NQ1; i++){
		for(j=1; j<=NQ1; j++)
			trueLmdom[i][j] = truePi[i][j];
		for(j=1; j<=NX; j++)	
			trueLmdom[i][j+NQ1] = trueB[i][j];
		for(j=1; j<=NT; j++)
			trueLmdom[i][j+NX+NQ1] = trueGamma[i][j];
		// for the spline case, the there is no true gamma, only true fi(x)
	}
	npar = allparasim(trueparameters, trueLmdy, trueLmdom, truepsi, truepsz, truePhi, lassolmd);
	printf("\n There are %d parameters!", npar);


	/////////////////////////////
	// Hyperparameter settings
	/////////////////////////////

	rho0 = 8; 
	for(i=1; i<=NY; i++)
		H0y[i][i] = .25;
	for(i=1; i<=NX; i++)
		for(j=1; j<=NX; j++){
			Phi0[i][j] = truePhi[i][j];
			R0[i][j] = 5.0*Phi0[i][j];
		}
	for(i=1; i<=NP; i++){
		a0psi[i] = 10.0;	b0psi[i] = 4.0;
		for(j=1; j<=Nr; j++)
			mu0y[i][j] = trueAm[i][j];
		for(j=1; j<=NQ; j++)
			mu0y[i][j+Nr] = trueLmd[i][j];
		for(j=1; j<=NY; j++)
			for(k=1; k<=NY; k++)
				h0y[i][j][k] = H0y[j][k];
	}
	for(i=1; i<=NQ1; i++){
		a0psz[i] = 10.0;	b0psz[i] = 4.0;
	}
	s2omi = 2.5;		// variance of proposal density of omega_i
	for(i=1; i<=Nlassolmd; i++){
		lassor0[i] = 1.0;	lassodt0[i] = 0.1;		
	}



	/////////////////////////
	// Initial MCMC Chain 
	/////////////////////////
	// To estimate the scales of unknown latent variables
	// Parametric nonlinear SE used here
	if(standardize==1){ 

		int	nt=4, nst=NQ1+NX+nt; // nt includes intercept, ksi1, ksi2, ksi1*ksi2
		DeltaH = zerodmatrix(nt, NQ2);
		for(i=1; i<=nt; i++)
			for(j=1; j<=NQ2; j++)
				DeltaH[i][j] = 0.0;
		DeltaH[2][1] = DeltaH[3][2] = 1.0;

		/////////////////////////////////
		// Set initial values for MCMC
		/////////////////////////////////

		// for SE
		for(i=1; i<=NQ1; i++){
			for(j=1; j<=NQ1; j++)
				Pi[i][j] = truePi[i][j];
			for(j=1; j<=NX; j++)
				B[i][j] = 1.0;
			for(j=1; j<=nt; j++)
				Gamma[i][j] = 0.0;
			psz[i] = 1.0;
			for(j=1; j<=Nlassolmd; j++)
				lassolmd[i][j]=1.0;
			for(j=1; j<=Ndlmd; j++)
				dlmdom[i][j] = 1.0;
		}
		for(i=1; i<=NQ2; i++){
			for(j=1; j<=NQ2; j++)
				Phi[i][j] = 0.1; 
			Phi[i][i] = 1.0; 
		}
		// for ME
		for(i=1; i<=NP; i++){
			for(j=1; j<=Nr; j++){
				Am[i][j] = trueAm[i][j];
				mu0y[i][j] = trueAm[i][j];
			}
			for(j=1; j<=NQ; j++){
				Lmd[i][j] = trueLmd[i][j];
				mu0y[i][j+Nr] = trueLmd[i][j];
			}
			psi[i] = 0.5;
		}
		Am[4][4]=Am[5][5]=Am[6][6]=Am[7][7]=Am[8][8]=Am[9][9]=1.0; 
		Lmd[2][1]=Lmd[3][1]=Lmd[5][2]=Lmd[6][2]=Lmd[8][3]=Lmd[9][3]=0.7;
		cbind(Lmdy, NP, Am, Nr, Lmd, NQ);

		// for Omega
		init(Pi, B, Gamma, Phi, psz, X, Omg, nt); 

		// Prepare matrices used later
		for(i=1; i<=NN; i++)
			for(j=1; j<=NY; j++){
				if(j<=Nr)	Gy[j][i] =  C[j][i];
				else	Gy[j][i] = Omg[j-Nr][i];
			}
		for(i=1; i<=NQ1; i++){
			for(j=1; j<=NQ1; j++)
				Lmdom[i][j] = Pi[i][j];
			for(j=1; j<=NX; j++)	
				Lmdom[i][j+NQ1] = B[i][j];
			for(j=1; j<=nt; j++)
				Lmdom[i][j+NX+NQ1] = Gamma[i][j];
		}
		npar = allparasim(allparameters, Lmdy, Lmdom, psi, psz, Phi, lassolmd);


		int			ms, burnin0;
		double**	Gm = dmatrix(1, NST, 1, NN);
		double*		xi = dvector(1, NX);
		double*		Omi = dvector(1, NQ);
		double*		Gmi = dvector(1, NST);
		double**	meanKsiT=zerodmatrix(NQ2, NN);
		double**	meanOmg=zerodmatrix(NQ, NN);
		meanGm = zerodvector(NST);
		stdGm = zerodvector(NST);

		ms = min(burnin, M);
		burnin0 = (int) floor(ms/2.0);
		for(m=1; m<=ms; m++){
			if(m%100==0)	
				printf("\n MCMC sample %d for standardization!", m);
				OneStepMCMCpara(Gy, Lmdy, mindex, ry, psi, Lmdom, dlmdom, psz, Phi, Y, lassolmd, X, DeltaH, 
						 mu0y, h0y, a0psi, b0psi, a0psz, b0psz, lassor0, lassodt0, R0, rho0,
						 s2omi, accept, 0, nt);
			if(m>burnin0){			
				for(i=1; i<=NN; i++){
					for(j=1; j<=NQ; j++)
						meanOmg[j][i] += Gy[Nr+j][i];
					for(j=1; j<=NQ2; j++) 
						meanKsiT[j][i] += Gy[Nr+NQ1+j][i];
				}
			}
		} // for each mcmc sample m

		for(i=1; i<=NN; i++){
			for(j=1; j<=NQ; j++)
				meanOmg[j][i] /= (ms-burnin0);
			for(j=1; j<=NQ2; j++) 
				meanKsiT[j][i] /= (ms-burnin0);
		}
		Knots = createknots(meanKsiT, NK, NN, NQ2);	

		for(i=1; i<=NN; i++){
			for(j=1; j<=NX; j++)
				xi[j] = X[j][i];
			for(j=1; j<=NQ; j++)
				Omi[j] = meanOmg[j][i];
			gxi2(Gmi, xi, Omi);
			for(j=1; j<=NST; j++)
				Gm[j][i] = Gmi[j];
		}
		mean(meanGm, Gm, NST, NN, 1);
		stdm(stdGm, Gm, NST, NN, 1);

		for(i=1; i<=NQ1; i++){
			meanGm[i] = 0.0; stdGm[i] = 1.0;
		}
		meanGm[NQ1+NX+1] = 0.0; stdGm[NQ1+NX+1] = 1.0;

		free_dmatrix(Gm, 1, NST, 1, NN);
		free_dvector(xi, 1, NX);
		free_dvector(Omi, 1, NQ);
		free_dvector(Gmi, 1, NST);
		free_dmatrix(meanKsiT, 1, NQ2, 1, NN);
		free_dmatrix(meanOmg, 1, NQ, 1, NN);
		free_dmatrix(DeltaH, 1, nt, 1, NQ2);
		DeltaH = zerodmatrix(NT, NQ2);
		deltaH(DeltaH, Knots, NK);
		DeltaHstd = dmatrix(1, NT, 1, NQ2);
		for(i=1; i<=NT; i++)
			for(j=1; j<=NQ2; j++)
				DeltaHstd[i][j] = DeltaH[i][j]/stdGm[i+NQ1+NX];
		savestd(meanGm, stdGm);
	} //if standardization


	// Set initial values for spline coefficients
	for(i=1; i<=NQ1; i++)
		for(j=1; j<=NT; j++)
			Gamma[i][j] = 0.0;
	for(i=1; i<=NQ1; i++){
		for(j=1; j<=NT; j++)
			Lmdom[i][j+NX+NQ1] = Gamma[i][j];
	}


	//////////////////
	// MCMC Sampling
	//////////////////
	double* zeromean = zerodvector(NST);
	for(m=1; m<=M; m++){
		if(m%100==0)	
			printf("\n MCMC sample %d!", m);
		for(i=1; i<=NN; i++)	accept[i] = 0.0;		
		OneStepMCMCstd(Gy, Lmdy, mindex, ry, psi, Lmdom, dlmdom, psz, Phi, Y, lassolmd, X, DeltaHstd, 
				 mu0y, h0y, a0psi, b0psi, a0psz, b0psz, lassor0, lassodt0, R0, rho0,
				 s2omi, accept, zeromean, stdGm, 1);				
		npar = allparasimstd(allparameters, Lmdy, Lmdom, psi, psz, Phi, lassolmd, stdGm);
		avgaccept += sum(accept, NN)/NN;
		if(m>burnin){
			for(i=1; i<=npar; i++)
				meanparameters[i] += allparameters[i];
		}
	} // for mcmc sample m
	free_dvector(zeromean, 1, NST);
	avgaccept /= (1.0*M);

	for(i=1; i<=npar; i++)
		meanparameters[i] /= (M-burnin);

	if(testprint){	
		cout << "\n\n /////////////////////////";
		cout << "\n // Results of MCMC chain //";
		cout << "\n ///////////////////////////\n";
		printf("\n The average acceptance rate after %d iterations for all omega is %f: \n", M, avgaccept);
		printsim(meanparameters, Lmdy, psi);
	}	
	printf("\n End of MCMC!");

	//printf("\n Test! Enter an interger:");
	//scanf("%d", &test);


	free_imatrix(indm, 1, NP, 1, NY);		free_dmatrix(C, 1, Nr, 1, NN);
	free_dmatrix(trueAm, 1, NP, 1, Nr);	free_dmatrix(trueLmd, 1, NP, 1, NQ);	
	free_dmatrix(trueB, 1, NQ1, 1, NX);		free_dmatrix(truePhi, 1, NX, 1, NX);
	free_dmatrix(trueGamma, 1, NQ1, 1, NT);	free_dmatrix(truePi, 1, NQ1, 1, NQ1);
	free_dvector(truepsi, 1, NP);	free_dvector(truepsz, 1, NQ1);	free_dmatrix(Xt, 1, NN, 1, NX);
	free_dmatrix(X, 1, NX, 1, NN);	free_dmatrix(trueLmdy, 1, NP, 1, NY);
	free_dmatrix(trueKsi, 1, NN, 1, NQ2);	free_dmatrix(trueEta, 1, NN, 1, NQ1);
	free_dmatrix(trueOmg, 1, NN, 1, NQ);	 
	free_dmatrix(Knots, 1, NQ2, 1, NK);
	free_ivector(ry, 1, NP);	free_imatrix(mindex, 1, NP, 1, NY);	

	free_dvector(a0psi, 1, NP);			free_dvector(b0psi, 1, NP); 
	free_dvector(a0psz, 1, NQ1);		free_dvector(b0psz, 1, NQ1);
	free_dvector(lassor0, 1, Nlassolmd);		free_dvector(lassodt0, 1, Nlassolmd);
	free_dmatrix(H0y, 1, NY, 1, NY);
	free_dmatrix(Phi0, 1, NX, 1, NX);	free_dmatrix(R0, 1, NX, 1, NX);
	free_dmatrix(mu0y, 1, NP, 1, NY);	free_dmatrix3(h0y, 1, NP, 1, NY, 1, NY);

	free_dmatrix(Am, 1, NP, 1, Nr);		free_dmatrix(Lmd, 1, NP, 1, NQ);
	free_dmatrix(B, 1, NQ1, 1, NX);
	free_dmatrix(Phi, 1, NX, 1, NX);		free_dmatrix(Gamma, 1, NQ1, 1, NT);
	free_dmatrix(Pi, 1, NQ1, 1, NQ1);	free_dvector(psi, 1, NP);
	free_dvector(psz, 1, NQ1);			free_dmatrix(Lmdy, 1, NP, 1, NY);
	free_dmatrix(Omg, 1, NQ, 1, NN);	free_dmatrix(lassolmd, 1, NQ1, 1, Nlassolmd);
	free_dmatrix(Gy, 1, NY, 1, NN);		free_dmatrix(Lmdom, 1, NQ1, 1, NST);
	free_dmatrix(dlmdom, 1, NQ1, 1, Ndlmd);	free_dmatrix(Y, 1, NP, 1, NN);
	free_dmatrix(DeltaH, 1, NT, 1, NQ2);
	free_dmatrix(trueLmdom, 1, NQ1, 1, NST);	 

	free_dvector(accept, 1, NN);
	free_dvector(trueparameters, 1, maxpara);
	free_dvector(allparameters, 1, maxpara);
	free_dvector(meanparameters, 1, maxpara);

	if(standardize){
		free_dvector(meanGm, 1, NST);
		free_dvector(stdGm, 1, NST);
		free_dmatrix(DeltaHstd, 1, NT, 1, NQ2);
	}

	printf("\n Enter an interger to exit:");
	scanf("%d", &test);
} // End main()
