# include <malloc.h>
# include <cstdio>
//# include <cstdlib>
# include <cmath>   
# include <iostream>
# include <cstring>
# include <fstream>
# include "nrutil.h" 
 
//using namespace std;
 

#define NR_END 1
#define FREE_ARG char*


void nrerror(const char* error_text)
{
//	void exit(int);
	int test;

	fprintf(stderr,"Numerical Recipes run-time error...\n");
	fprintf(stderr,"%s\n",error_text);
	fprintf(stderr,"...now exiting to system...\n");
	printf("\n Error! Enter an interger to exit:");
	scanf("%d", &test);
	exit(1);
}
 


float *vector(int nl, int nh)
{
	float *v;

	v=(float *)malloc((unsigned) (nh-nl+1)*sizeof(float));
	if (!v) nrerror("allocation failure in vector()");
	return v-nl;
}


int *ivector(int nl, int nh)
{
	int *v;

	v=(int *)malloc((unsigned) (nh-nl+1)*sizeof(int));
	if (!v) nrerror("allocation failure in ivector()");
	return v-nl;
}

 
double *dvector(int nl, int nh)
{
	double *v;

	v=(double *)malloc((unsigned) (nh-nl+1)*sizeof(double));
	if (!v) nrerror("allocation failure in vector()");
	return v-nl;
}
 


float **matrix(int nrl, int nrh, int ncl, int nch)
{
	int i;
	float **m;

	m=(float **) malloc((unsigned) (nrh-nrl+1)*sizeof(float*));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(float *) malloc((unsigned) (nch-ncl+1)*sizeof(float));
		if (!m[i]) nrerror("allocation failure 2 in matrix()");
		m[i] -= ncl;
	}
	return m;
}

double **dmatrix(int nrl, int nrh, int ncl, int nch)
{
	int i;
	double **m;

	m=(double **) malloc((unsigned) (nrh-nrl+1)*sizeof(double*));
	if (!m) {
		printf("\n Error in creating dmatrix(%d, %d, %d, %d)", nrl, nrh, ncl, nch);
		nrerror("\n allocation failure 1 in dmatrix");
	}
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(double *) malloc((unsigned) (nch-ncl+1)*sizeof(double));
		if (!m[i]){
			printf("\n Error in creating dmatrix(%d, %d, %d, %d)", nrl, nrh, ncl, nch);
			nrerror("\n allocation failure 2 in dmatrix()");
		}
		m[i] -= ncl;
	}
	return m;
}

int **imatrix(int nrl, int nrh, int ncl, int nch)
{
	int i,**m;

	m=(int **)malloc((unsigned) (nrh-nrl+1)*sizeof(int*));
	if (!m) nrerror("allocation failure 1 in imatrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(int *)malloc((unsigned) (nch-ncl+1)*sizeof(int));
		if (!m[i]) nrerror("allocation failure 2 in imatrix()");
		m[i] -= ncl;
	}
	return m;
}


void free_vector(float *v, int nl, int nh)
{
	free((char*) (v+nl));
}

void free_ivector(int *v, int nl, int nh)
{
	free((char*) (v+nl));
}

void free_dvector(double *v, int nl, int nh)
{
	free((char*) (v+nl));
}


void free_matrix(float **m, int nrl, int nrh, int ncl, int nch)
{
	int i;

	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}

void free_dmatrix(double **m, int nrl, int nrh, int ncl, int nch)
{
	int i;

	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}

void free_imatrix(int **m, int nrl, int nrh, int ncl, int nch)
{
	int i;

	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}


double ***dmatrix3(int nrl, int nrh, int ncl, int nch, int n3l, int n3h)
{
  int i, j;
  double ***m;
  void nrerror(const char *);

  m=(double ***) malloc((unsigned) (nrh-nrl+1)*sizeof(double**));
  if (!m) nrerror("error in dmatrix3");
  m -= nrl;
  for(i=nrl; i<=nrh;i++) {
    m[i]=(double **) malloc((unsigned) (nch-ncl+1)*sizeof(double*));
    if (!m[i]) nrerror("error in dmatrix3");
    m[i] -= ncl;
    for(j=ncl; j<=nch; j++){
      m[i][j]=(double *) malloc((unsigned) (n3h-n3l+1)*sizeof(double));
      if (!m[i][j]) nrerror("error in dmatrix3");
	  m[i][j] -= n3l;
    }      
  }
  return m;
}


void free_dmatrix3(double ***m, int nrl, int nrh, int ncl, int nch, int n3l, int n3h) 
{
	int i,j;
	for(i=nrh;i>=nrl;i--)
   	   for(j=nch;j>=ncl;j--)
		free((char*) (m[i][j]+n3l));
	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}


