#ifndef NRUTIL_H
#define NRUTIL_H

#ifdef __STDC__
#define PI 3.1415926f
#else
#define PI 3.1415926
#endif


void nrerror(const char* error_text);
float *vector(int nl, int nh);
int *ivector(int nl, int nh);
double *dvector(int nl, int nh);
float **matrix(int nrl, int nrh, int ncl, int nch);
double **dmatrix(int nrl, int nrh, int ncl, int nch);
double ***dmatrix3(int nrl, int nrh, int ncl, int nch, int n3l, int n3h);
int **imatrix(int nrl, int nrh, int ncl, int nch);

void free_vector(float *v, int nl, int nh);
void free_ivector(int *v, int nl, int nh);
void free_dvector(double *v, int nl, int nh);
void free_matrix(float **m, int nrl, int nrh, int ncl, int nch);
void free_dmatrix(double **m, int nrl, int nrh, int ncl, int nch);
void free_imatrix(int **m, int nrl, int nrh, int ncl, int nch);
void free_dmatrix3(double ***m, int nrl, int nrh, int ncl, int nch, int n3l, int n3h);

#endif 

