#ifndef SEM_H
#define SEM_H


# include <iostream>
# include <string>
# include <fstream>
# include "functions.h"

using namespace std;

extern int NN, NP, NQ, NQ1, NQ2, NX, NT, Nr, NST, NY, R;
extern int NK, NF, R, Nlassolmd;	
extern int test, testprint, standardize;
extern unsigned int congrval,tausval;
extern double**	Knots;


// Simulation for Splines
int		allparasim(double *para, double **lmdy, double **lmdom, double *psi, double *psz,
			 double **Phi, double **lassolmd);
void	printsim(double *avgpara, double **lmdy, double *psi);
int		allparasimstd(double *para, double **lmdy, double **lmdom, double *psi, double *psz,
			 double **Phi, double **lassolmd, double *sstd);
void	sim(int**	indm, double**	C, double**	Am, double** trueLmd, 
		 double** B, double**	Phi, double** Pi, double* psi, double* psz, double** X, 
		double** Lmdy, double** ksi, double** eta, double** Omg, double **Y);
void	savesim(double **YV, double **XV, int n, int p, int s, char *filename);


// Prepare SEM inputs
double* Hksii(double *ksii);
double* Hksii(double *ksii, double **knots);
void	gxi2(double *gx2, double *xi, double *omi);
void	init(double **Pi, double **B,double **Gamma, double **PHI,double *PSD,double **X,double **om);
double	pomegai(double **Am, double *ci, double **Lmd,double *omi,double *yi,double *xi,double *Psi,double **Phi,double **gm,double *Psd);
void	omiprop(double *propomi, double *oldomi, double s2omi, double **Lmd, double **Phi, double **gm, double *Psd, double *Psi, double **Deltah);
double	pomegaistd(double **Am, double *ci, double **Lmd,double *omi,double *yi,double *xi,double *Psi,double **Phi,double **gm,double *Psd, double *mstd, double *sstd);
double	omiMHstd(double *newomi, double *oldomi, double *yi, double *xi, double **Am, 
				double *ci, double **gm, double s2omi, double **Lmd, double *Psi, 
				double *Psd, double **Phi, double **lmdom, double **Deltah,
				double *mstd, double*sstd);

// Update (A, Lambda), and psi_k without penalization
double	genME(double *lmdyk, int ryk, int *mindk, double *yk, double **gy, double psik0, double *mu0yk, double **h0yk, double a0, double b0);

// Update (Pi, B, Gamma) by Lasso for structure equation
void	genPhi(double **Phi, double **R0, int r0, double **Omg2);
double	genbeta0k(double pszk, double *etak, double *lmdomk, double **gom);
void	genLMDomk0(double *lmdomk, double *omk, double **go, double *dlmdomk, double pszk);
void	genDlmdomk0(double *dlmdomk, double *lmdomk, double pszk, double lpk, double lbk, double lgk);
double	genpszk0(double a0, double b0, double *omk, double **go, double *lmdomk, double *dlmdomk);

// Update regularization parameter
void	lassolmdk1(double *lmd, double *r0, double *dt0, double *dlmdomk);


// MCMC
void	OneStepMCMCstd(double **gy, double **lmdy, int **mindex, int *ry, double *psi, double **lmdom, 
				 double **dlmdom, double *psz, double **Phi, double **Y, double **lassolmd, double **X,  
				 double **Deltah, double **mu0y, double ***h0y, double *a0psi, double *b0psi, 				 
				 double *a0psz, double *b0psz, double *lassor0, double *lassodt0, 
				 double **R0, int r0, double s2omi, double *accept, double* mstd, double *sstd, int penalize);
void	savestd(double *mstd, double *sstd);

// Functions for SEM Spline Version
// for Natural Cubic Splines
double	dk(double x, double kk, double kK);
void	ns(double **mbasis, double *xv, double *knots, int N, int K);
void	basis(double **nsbasis, double **ksi, double **knots, int N, int K);
double*	dNk(double *knots, int K);
double* Nk0(double *knots, int K);
double** createknots(double **xv, int K, int N, int nv);
void	deltaH(double **dh, double **knots, int K);


// Functions for initial MCMC chain using parametric nonlinear SE
void	init(double** Pi, double **B,double **Gamma, double **PHI,double *PSD,double **X,double **om, int nt);
double	omiMH(double *newomi, double *oldomi, double *yi, double *xi, double **Am, double *ci, double **gm, double s2omi, double **Lmd, double *Psi, double *Psd, double **Phi, double **lmdom, double **Deltah, int nt);
double	pomegai(double **Am, double *ci, double **Lmd,double *omi,double *yi,double *xi,double *Psi,double **Phi,double **gm,double *Psd, int nt);
void	omiprop(double *propomi, double *oldomi, double s2omi, double **Lmd, double **Phi, double **gm, double *Psd, double *Psi, double **Deltah, int nt);
double* Hksii(double *ksii, int nt);
void	gxi2(double *gx2, double *xi, double *omi, int nt);
double	genbeta0k(double pszk, double *etak, double *lmdomk0, double **gom0, int nt);
void	genLMDomk0(double *lmdomk, double *omk, double **go, double *dlmdomk, double pszk, int nt);
void	genDlmdomk0(double *dlmdomk, double *lmdomk, double pszk, double lpk, double lbk, double lgk, int nt);
double	genpszk0(double a0, double b0, double *omk, double **go, double *lmdomk, double *dlmdomk, int nt);
void	lassolmdk1(double *lmd, double *r0, double *dt0, double *dlmdomk, int nt);
void	OneStepMCMCpara(double **gy, double **lmdy, int **mindex, int *ry, double *psi, double **lmdom, 
				 double **dlmdom, double *psz, double **Phi, double **Y, double **lassolmd, 
				 double **X, double **Deltah, double **mu0y, double ***h0y, double *a0psi, 
				 double *b0psi, double *a0psz, double *b0psz, double *lassor0, double *lassodt0, 
				 double **R0, int r0, double s2omi, double *accept, int penalize, int nt);

/*
Notations:

NQ1: q1;	NST: s+t

Am:		p*r matrix A in the measurement equation
LMD:	Lambda matrix in measurement equation
Lmd:	function parameter version of LMD
LMDomg:	a q1*(q1+s+t) matrix of (Pi, B, Gamma) in the structural equation
GMX:	(Pi, B, Gamma) in the structural equation; 
		Here,GMX=(B, Gamma), since eta is 1*1.
PHI:	ksi_i ~ N(0, PhI)

omi:	(eta_i, ksi_i) = w_i
ksii:	the exogenous variable ksi_i 
ci:		fixed variables in measurement equation
gm:		(Pi, B, Gamma) in the structural equation
Psi:	Psi_epsilon for measurement equation
Psd:	Psi_zeta for structural equation
DeltaH:	the first derivative of H(ksii) wrt. ksii

LMDy:	(A, Lambda) in the measurement eqn, p*(r+q) matrix
Gy:		(C^T, Omega^T)^T in the measurement eqn,(r+q)*n matrix	
C:		(c1, ..., cn) in ME, r*n matrix
Omega:	(omega1, ..., omegan) in ME, q*n matrix
A:		in ME, p*r matrix
Go:		(go1, ..., gon) in the SE,(q1+s+t)*n matrix	
goi:	(eta_i^T, x_i^T, H(xi_i)^T)^T, (q1+s+t)*1 matrix
lmdom:	(Pi, B, Gamma) in the structural equation; 
dlmdy:	(r+q)*(r+q) matrix, k-th row of dlmdy is dlmdyk = diag(D_Lmdyk)

*/

#endif;